/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xml;

import java.io.InputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class BerliozEntityResolver
implements EntityResolver {
    public static final String PUBLIC_ID_PREFIX = "-//Weborganic//DTD::Berlioz ";
    private static final String ALIAS_ID_PREFIX = "-//Berlioz//DTD::";
    private static final String PUBLIC_ID_SUFFIX = "//EN";
    private static final BerliozEntityResolver SINGLETON = new BerliozEntityResolver();
    private static final Logger LOGGER = LoggerFactory.getLogger(BerliozEntityResolver.class);

    private BerliozEntityResolver() {
    }

    @Override
    public @Nullable InputSource resolveEntity(@Nullable String publicId, String systemId) {
        InputSource source = null;
        String dtd = BerliozEntityResolver.toFileName(publicId);
        if (dtd != null) {
            LOGGER.debug("resolved {} to /library/{}", (Object)publicId, (Object)dtd);
            InputStream inputStream = BerliozEntityResolver.class.getResourceAsStream("/library/" + dtd);
            source = new InputSource(inputStream);
        } else {
            LOGGER.info("Tried to use the entity resolver on unknown public ID '{}'", (Object)publicId);
        }
        return source;
    }

    public static BerliozEntityResolver getInstance() {
        return SINGLETON;
    }

    protected static @Nullable String toFileName(@Nullable String publicId) {
        if (publicId == null) {
            return null;
        }
        if (!publicId.endsWith(PUBLIC_ID_SUFFIX)) {
            return null;
        }
        int length = publicId.length() - PUBLIC_ID_SUFFIX.length();
        if (publicId.startsWith(PUBLIC_ID_PREFIX)) {
            return publicId.substring(PUBLIC_ID_PREFIX.length(), length).toLowerCase().replace(' ', '-') + ".dtd";
        }
        if (publicId.startsWith(ALIAS_ID_PREFIX)) {
            return publicId.substring(ALIAS_ID_PREFIX.length(), length).toLowerCase().replace(' ', '-') + ".dtd";
        }
        return null;
    }
}

