/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceCompressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceCompressor.class);

    private ResourceCompressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(CharSequence content, Charset charset) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(content.length());
        byte[] compressed = null;
        GZIPOutputStream compressor = null;
        try {
            compressor = new GZIPOutputStream(os);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)compressor, charset);
            w.write(content.toString());
            ((Writer)w).close();
            compressor.finish();
            compressed = os.toByteArray();
        }
        catch (IOException ex) {
            compressed = new byte[]{};
        }
        finally {
            try {
                if (compressor != null) {
                    compressor.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to close GZIPOutputStream stream", (Throwable)ex);
            }
            os = null;
            compressor = null;
        }
        return compressed;
    }
}

