/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTypes.class);
    private static final Properties MEDIATYPES = new Properties();

    private MediaTypes() {
    }

    public static @Nullable String getMediaType(File f) {
        String name;
        int dot;
        if (MEDIATYPES.isEmpty()) {
            MediaTypes.loadMediaTypes();
        }
        if ((dot = (name = f.getName()).lastIndexOf(".")) >= 0) {
            return MEDIATYPES.getProperty(name.substring(dot + 1));
        }
        return null;
    }

    private static synchronized void loadMediaTypes() {
        try (InputStream in = MediaTypes.getMediaTypesInputStream();){
            if (in != null) {
                MEDIATYPES.load(in);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to load MIME properties", (Throwable)ex);
        }
    }

    private static @Nullable InputStream getMediaTypesInputStream() throws IOException {
        File file = new File(GlobalSettings.getWebInf(), "config/mediatypes.properties");
        if (file.exists()) {
            LOGGER.info("Loading MIME properties from {}", (Object)file.getAbsolutePath());
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        LOGGER.info("Loading MIME properties from Berlioz JAR", (Object)file.getAbsolutePath());
        return MediaTypes.class.getResourceAsStream("/mime.properties");
    }
}

