/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5 {
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static final int BYTE_MASK_HIGH = 240;
    private static final int BYTE_MASK_LOW = 15;

    private MD5() {
    }

    public static String hash(String text) throws UnsupportedOperationException {
        MessageDigest md = MD5.getAlgorithm();
        md.update(text.getBytes(StandardCharsets.UTF_8), 0, text.length());
        byte[] bytes = md.digest();
        return MD5.toHex(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(File file) throws IOException, UnsupportedOperationException {
        MessageDigest md = MD5.getAlgorithm();
        FileInputStream fis = new FileInputStream(file);
        FileChannel in = fis.getChannel();
        try {
            MappedByteBuffer buffer = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
            md.update(buffer);
            byte[] bytes = md.digest();
            String string = MD5.toHex(bytes);
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String hash(File file, boolean strong) throws IOException, UnsupportedOperationException {
        if (strong) {
            return MD5.hash(file);
        }
        return MD5.hash(file.getCanonicalPath() + '$' + file.length() + '%' + file.lastModified());
    }

    private static String toHex(byte[] data) {
        StringBuilder hex = new StringBuilder(2 * data.length);
        int shift = 4;
        for (byte b : data) {
            hex.append(HEX[(b & 0xF0) >> 4]).append(HEX[b & 0xF]);
        }
        return hex.toString();
    }

    private static MessageDigest getAlgorithm() throws UnsupportedOperationException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }
}

