/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.util.EntityInfo;

public class FileEntityInfo
implements EntityInfo {
    private final File _file;
    private final long modified;
    private final long length;
    private final String mime;

    public FileEntityInfo(File file, String mimeType) {
        boolean ok = file.exists();
        this._file = file;
        this.modified = ok ? file.lastModified() : -1L;
        this.length = ok ? file.length() : -1L;
        this.mime = mimeType;
    }

    @Override
    public final long getLastModified() {
        return this.modified;
    }

    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final @NonNull String getMimeType() {
        return this.mime;
    }

    @Override
    public final @Nullable String getETag() {
        if (this.length >= 0L || this.modified >= 0L) {
            return "\"" + this.length + "-" + this.modified + "\"";
        }
        return null;
    }

    public final File getFile() {
        return this._file;
    }
}

