/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.GeneratorListener;
import org.pageseeder.berlioz.servlet.BerliozConfig;
import org.pageseeder.berlioz.system.StatisticsCollector;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetGeneratorStatistics
implements ContentGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetGeneratorStatistics.class);

    public GetGeneratorStatistics() {
        GeneratorListener listener = BerliozConfig.getListener();
        StatisticsCollector collector = StatisticsCollector.getInstance();
        if (listener == null) {
            BerliozConfig.setListener(collector);
        } else if (collector != listener) {
            LOGGER.warn("Unable to initialise the Berlioz statistics for generators");
        }
    }

    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        StatisticsCollector collector = StatisticsCollector.getInstance();
        if ("true".equals(req.getParameter("reset", "false"))) {
            collector.clear();
        }
        collector.toXML(xml);
    }
}

