/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.util.Properties;
import javax.xml.transform.Templates;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.servlet.BerliozOutput;

public final class XSLTransformResult
implements BerliozOutput {
    private final CharSequence _content;
    private final long _time;
    private final Status _status;
    private final @Nullable Exception _ex;
    private final @Nullable String _error;
    private String mediaType = "text/html";
    private String encoding = "utf-8";

    public XSLTransformResult(CharSequence content, long time, Templates templates) {
        this._content = content;
        this._time = time;
        this._status = Status.OK;
        this._error = null;
        this._ex = null;
        if (templates != null) {
            this.setOutputProperties(templates);
        }
    }

    public XSLTransformResult(CharSequence content, Exception ex, @Nullable Templates templates) {
        this._content = content;
        this._time = 0L;
        this._status = Status.ERROR;
        this._error = null;
        this._ex = ex;
        if (templates != null) {
            this.setOutputProperties(templates);
        }
    }

    @Override
    public CharSequence content() {
        return this._content;
    }

    public long time() {
        return this._time;
    }

    public Status status() {
        return this._status;
    }

    public @Nullable String getErrorMessage() {
        return this._error;
    }

    public @Nullable Exception getException() {
        return this._ex;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    protected void setOutputProperties(Templates templates) {
        Properties p = templates.getOutputProperties();
        this.encoding = p.getProperty("encoding", "utf-8");
        this.mediaType = p.getProperty("media-type", "text/html");
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

