/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.content.Location;
import org.pageseeder.berlioz.content.PathInfo;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.furi.URIResolveResult;
import org.pageseeder.berlioz.security.NonceFactory;
import org.pageseeder.berlioz.servlet.CoreHttpRequest;
import org.pageseeder.berlioz.servlet.HttpRequestWrapper;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLResponseHeader
implements XMLWritable {
    private static final Pattern VALID_XML_NAME = Pattern.compile("[a-zA-Z_][-a-zA-Z0-9_.]*");
    private static final NonceFactory NONCE_FACTORY = new NonceFactory();
    private final CoreHttpRequest _core;
    private final String _service;
    private final String _group;
    private final URIResolveResult _results;

    protected XMLResponseHeader(CoreHttpRequest core, Service service, URIResolveResult results) {
        this._core = core;
        this._service = service.id();
        this._group = service.group();
        this._results = results;
    }

    public void toXML(XMLWriter xml) throws IOException {
        Location location;
        HttpServletRequest req = this._core.request();
        boolean compatibility = !"1.0".equals(GlobalSettings.get(BerliozOption.XML_HEADER_VERSION));
        xml.openElement("header", true);
        if (compatibility) {
            xml.writeComment("Elements below will be deprecated in Berlioz 1.0");
            xml.element("group", this._group);
            xml.element("service", this._service);
            xml.writeComment("Use 'path' instead");
            xml.element("path-info", HttpRequestWrapper.getBerliozPath(req));
            xml.element("context-path", req.getContextPath());
            xml.writeComment("Use 'location' instead");
            xml.element("scheme", req.getScheme());
            xml.element("host", req.getServerName());
            xml.element("port", Integer.toString(req.getServerPort()));
            xml.element("url", req.getRequestURL().toString());
            xml.element("query-string", req.getQueryString());
            xml.writeComment("End deprecated elements");
        }
        if ((location = this._core.location()) != null) {
            location.toXML(xml);
            PathInfo path = location.info();
            path.toXML(xml);
        }
        xml.openElement("http-parameters", true);
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            Object values;
            String name = (String)names.nextElement();
            if (name == null || (values = req.getParameterValues(name)) == null) continue;
            for (String value : values) {
                xml.openElement("parameter", false);
                xml.attribute("name", name);
                xml.writeText(value);
                xml.closeElement();
            }
        }
        xml.closeElement();
        if (this._results != null) {
            Set<String> unames = this._results.names();
            xml.openElement("uri-parameters", !unames.isEmpty());
            for (String string : unames) {
                Object value = this._results.get(string);
                xml.openElement("parameter", false);
                xml.attribute("name", string);
                xml.writeText(value != null ? value.toString() : "");
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.openElement("berlioz");
        xml.attribute("version", GlobalSettings.getVersion());
        xml.attribute("mode", GlobalSettings.getMode());
        xml.closeElement();
        Properties app = GlobalSettings.getNode("berlioz.app");
        if (app != null && app.size() > 0) {
            xml.openElement("app");
            for (Map.Entry entry : app.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!VALID_XML_NAME.matcher(name).matches()) continue;
                xml.attribute(name, value);
            }
            xml.closeElement();
        }
        if (GlobalSettings.has(BerliozOption.NONCE_ENABLE)) {
            String attribute = GlobalSettings.get(BerliozOption.NONCE_ATTRIBUTE);
            boolean bl = attribute.length() > 0;
            String nonce = null;
            String source = "header";
            if (bl && req.getAttribute(attribute) != null) {
                nonce = req.getAttribute(attribute).toString();
            }
            if (nonce == null) {
                nonce = NONCE_FACTORY.generate();
                source = "berlioz";
                if (bl) {
                    req.setAttribute(attribute, (Object)nonce);
                }
            } else if (!nonce.matches("^[A-Za-z0-9+/=]*$")) {
                nonce = "";
                xml.writeComment("invalid nonce");
            }
            if (nonce.length() > 0) {
                xml.openElement("security");
                xml.attribute("nonce", nonce);
                xml.attribute("source", source);
                xml.closeElement();
            }
        }
        xml.closeElement();
    }
}

