/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.config.RedirectConfig;
import org.pageseeder.berlioz.config.RedirectLocation;
import org.pageseeder.berlioz.servlet.BerliozConfig;
import org.pageseeder.berlioz.servlet.HttpLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedirectFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 25684657834543L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectFilter.class);
    private @Nullable File configFile;
    private transient @Nullable RedirectConfig config = null;
    private String controlKey = "";

    public void init(FilterConfig config) {
        ServletContext context = config.getServletContext();
        File contextPath = new File(context.getRealPath("/"));
        File webinfPath = new File(contextPath, "WEB-INF");
        String mappingConfig = config.getInitParameter("config");
        this.controlKey = GlobalSettings.get(BerliozOption.XML_CONTROL_KEY);
        if (mappingConfig == null) {
            LOGGER.warn("Missing 'config' init-parameter - filter will have no effect");
            return;
        }
        File mappingFile = new File(webinfPath, mappingConfig);
        if (!mappingFile.exists()) {
            LOGGER.warn("'config' init-parameter points to non existing file {} - filter will have no effect", (Object)mappingFile.getAbsolutePath());
        }
        this.configFile = mappingFile;
    }

    public void destroy() {
        this.configFile = null;
        this.config = null;
        this.controlKey = "";
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            this.doHTTPFilter((HttpServletRequest)req, (HttpServletResponse)res, chain);
        }
    }

    public void doHTTPFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws ServletException, IOException {
        RedirectConfig config;
        RedirectLocation location;
        if ("true".equals(req.getParameter("berlioz-reload")) && BerliozConfig.hasControl(req, this.controlKey)) {
            this.config = null;
        }
        if ((location = (config = this.config()).redirect(req.getRequestURI())) != null) {
            res.setCharacterEncoding("utf-8");
            LOGGER.debug("Redirecting from {} to {}", (Object)location.from(), (Object)location.to());
            RedirectFilter.sendRedirect(req, res, location.to(), location.isPermanent());
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private RedirectConfig config() {
        RedirectConfig config = this.config;
        if (config == null) {
            try {
                config = RedirectConfig.newInstance(this.configFile);
                LOGGER.info("Loaded redirect configuration: {} rules found", (Object)config.size());
            }
            catch (ConfigException ex) {
                LOGGER.error("Unable to load configuration: {}", (Object)ex.getMessage());
                config = new RedirectConfig();
            }
            this.config = config;
        }
        return config;
    }

    private static void sendRedirect(HttpServletRequest req, HttpServletResponse res, String location, boolean permanent) throws ServletException {
        String url = location;
        if (location.indexOf("://") < 4) {
            StringBuilder buffer = HttpLocation.toBaseURL(req);
            if (!location.startsWith("/")) {
                throw new ServletException("Cannot use relative URL to redirect: " + location);
            }
            buffer.append(location);
            url = buffer.toString();
        }
        res.reset();
        res.setHeader("Location", url.replaceAll("[\\n\\r]+", ""));
        res.setHeader("Cache-Control", "max-age=86400, must-revalidate");
        if (permanent) {
            res.setStatus(301);
        } else {
            res.setStatus(302);
        }
        res.setContentLength(0);
    }
}

