/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.util.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Overlays {
    private static final Logger LOGGER = LoggerFactory.getLogger(Overlays.class);
    private static final String[] ILLEGAL_OVERLAY_FILEPATHS = new String[]{"/WEB-INF/web.xml", "/WEB-INF/config/config.xml", "/WEB-INF/config/services.xml"};

    private Overlays() {
    }

    public static List<Overlay> list(File root) {
        File webinfPath = new File(root, "WEB-INF");
        File overlays = new File(webinfPath, "overlays");
        if (overlays.exists() && overlays.isDirectory()) {
            File[] files = overlays.listFiles(f -> {
                String name = f.getName();
                return name.endsWith(".war") || name.endsWith(".zip") || name.endsWith(".jar");
            });
            ArrayList<Overlay> list = new ArrayList<Overlay>();
            if (files != null) {
                for (File f2 : files) {
                    Overlay overlay = new Overlay(f2);
                    list.add(overlay);
                }
                Collections.sort(list);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Beta
    static final class Overlay
    implements Comparable<Overlay> {
        private final File _source;
        private final String _name;
        private final String _version;

        private Overlay(File source) {
            this._source = source;
            String filename = source.getName();
            filename = filename.substring(0, filename.length() - 4);
            int dash = filename.lastIndexOf(45);
            this._name = dash >= 0 ? filename.substring(0, dash) : filename;
            this._version = dash >= 0 ? filename.substring(dash + 1) : "";
        }

        public String name() {
            return this._name;
        }

        public String version() {
            return this._version;
        }

        @Override
        public int compareTo(Overlay o) {
            int compare = this._name.compareTo(o._name);
            if (compare == 0) {
                compare = Versions.compare(this._version, o._version);
            }
            return compare;
        }

        public File getSource() {
            return this._source;
        }

        public int unpack(File root) throws IOException {
            String rootPath = root.getCanonicalPath();
            int unpacked = 0;
            long modified = this._source.lastModified();
            try (ZipFile zip = new ZipFile(this._source);){
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    File f;
                    boolean created;
                    File dir;
                    ZipEntry entry = e.nextElement();
                    String name = entry.getName();
                    Path path = Paths.get(rootPath, name).normalize();
                    boolean illegal = !path.startsWith(rootPath);
                    for (String illegalPath : ILLEGAL_OVERLAY_FILEPATHS) {
                        if (!path.endsWith(illegalPath)) continue;
                        illegal = true;
                        break;
                    }
                    if (illegal) {
                        LOGGER.warn("Ignoring illegal entry: {}", (Object)name);
                        continue;
                    }
                    if (name.startsWith("META-INF") || name.contains("__MACOSX") || name.endsWith(".DS_Store")) continue;
                    if (name.indexOf(47) > 0 && !(dir = path.getParent().toFile()).exists() && !(created = dir.mkdirs())) {
                        LOGGER.warn("Unable to create parent folder of: {}", (Object)name);
                    }
                    if (entry.isDirectory() || (f = path.toFile()).exists() && f.length() == entry.getSize() && f.lastModified() >= modified) continue;
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                    Throwable throwable = null;
                    try {
                        Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
                        ++unpacked;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            return unpacked;
        }

        public String toString() {
            return this._name + "[" + this._version + "]";
        }
    }
}

