/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.berlioz.content.Location;
import org.pageseeder.berlioz.content.PathInfo;
import org.pageseeder.berlioz.servlet.HttpPathInfo;
import org.pageseeder.berlioz.util.StringUtils;
import org.pageseeder.xmlwriter.XMLWriter;

public final class HttpLocation
implements Location,
Serializable {
    private static final long serialVersionUID = -7167736932510978113L;
    private static final int DEFAULT_PORT_HTTP = 80;
    private static final int DEFAULT_PORT_HTTPS = 443;
    private final String _scheme;
    private final String _host;
    private final int _port;
    private final String _path;
    private final String _query;
    private final PathInfo _info;

    private HttpLocation(HttpServletRequest req) {
        this._scheme = req.getScheme();
        this._host = req.getServerName();
        this._port = req.getServerPort();
        this._path = req.getRequestURI();
        String query = req.getQueryString();
        this._query = query != null ? query : "";
        this._info = new HttpPathInfo(req);
    }

    @Override
    public String scheme() {
        return this._scheme;
    }

    @Override
    public String host() {
        return this._host;
    }

    @Override
    public int port() {
        return this._port;
    }

    @Override
    public String path() {
        return this._path;
    }

    @Override
    public String query() {
        return this._query;
    }

    @Override
    public PathInfo info() {
        return this._info;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("location");
        xml.attribute("scheme", this._scheme);
        xml.attribute("host", this._host);
        xml.attribute("port", Integer.toString(this._port));
        xml.attribute("path", this._path);
        xml.attribute("query", this._query);
        StringBuilder url = new StringBuilder();
        url.append(this._scheme).append("://").append(this._host);
        if (!HttpLocation.isDefaultPort(this._scheme, this._port)) {
            url.append(':').append(this._port);
        }
        xml.attribute("base", url.toString());
        url.append(this._path);
        if (this._query.length() > 0) {
            url.append('?').append(this._query);
        }
        xml.writeText(url.toString());
        xml.closeElement();
    }

    public static HttpLocation build(HttpServletRequest req) {
        return new HttpLocation(req);
    }

    public static StringBuilder toBaseURL(HttpServletRequest req) {
        StringBuilder base = new StringBuilder();
        String scheme = HttpLocation.getScheme(req);
        int port = HttpLocation.getPort(req);
        base.append(scheme).append("://").append(req.getServerName());
        if (port > 0 && !HttpLocation.isDefaultPort(scheme, port)) {
            base.append(':').append(port);
        }
        return base;
    }

    private static String getScheme(HttpServletRequest req) {
        String scheme = req.getHeader("X-Forwarded-Proto");
        if (StringUtils.isBlank(scheme)) {
            scheme = req.getScheme();
        }
        return scheme;
    }

    private static int getPort(HttpServletRequest req) {
        int port = req.getServerPort();
        String reverseProxyScheme = req.getHeader("X-Forwarded-Proto");
        if (!StringUtils.isBlank(reverseProxyScheme)) {
            port = -1;
            String reverseProxyPort = StringUtils.substringAfter(req.getHeader("X-Forwarded-Host"), ":");
            if (reverseProxyPort.matches("[0-9]+")) {
                port = Integer.parseInt(reverseProxyPort);
            }
        }
        return port;
    }

    private static boolean isDefaultPort(String scheme, int port) {
        if (port < 0) {
            return true;
        }
        if (80 == port && "http".equals(scheme)) {
            return true;
        }
        return 443 == port && "https".equals(scheme);
    }
}

