/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozErrorID;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.ErrorID;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.http.HttpStatusCodes;
import org.pageseeder.berlioz.servlet.XSLTransformer;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.CompoundBerliozException;
import org.pageseeder.berlioz.util.ErrorCollector;
import org.pageseeder.berlioz.util.Errors;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = -2993007522046978323L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlerServlet.class);
    public static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String BERLIOZ_ERROR_ID = "org.pageseeder.berlioz.error_id";
    private static final String FORWARD_EXTENSIONS = ".html,.xml";
    private static final String IGNORE_EXTENSIONS = ".jpg,.png,.css,.js";
    private static final String AUTO_EXTENSION = ".auto";
    private static final String DEFAULT_EXTENSION = ".html";
    private static final Set<String> forwardExtensions = new HashSet<String>();
    private static final Set<String> ignoreExtensions = new HashSet<String>();
    private static String autoExtension = ".auto";
    private static String defaultExtension = ".html";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String preserve = config.getInitParameter("forward-extensions");
        if (preserve == null) {
            preserve = FORWARD_EXTENSIONS;
        }
        Collections.addAll(forwardExtensions, preserve.split(","));
        String ignore = config.getInitParameter("ignore-extensions");
        if (ignore == null) {
            ignore = IGNORE_EXTENSIONS;
        }
        Collections.addAll(ignoreExtensions, ignore.split(","));
        String defExt = config.getInitParameter("forward-default");
        defaultExtension = defExt != null ? defExt : DEFAULT_EXTENSION;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ErrorHandlerServlet.handle(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ErrorHandlerServlet.handle(req, res);
    }

    public static void handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String original;
        String ext;
        int code = ErrorHandlerServlet.getErrorCode((ServletRequest)req);
        String uri = req.getRequestURI();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Error handler for URI:{}", (Object)uri);
            LOGGER.debug("javax.servlet.error.message:{}", req.getAttribute(ERROR_MESSAGE));
            LOGGER.debug("javax.servlet.error.status_code:{}", req.getAttribute(ERROR_STATUS_CODE));
            LOGGER.debug("javax.servlet.error.servlet_name:{}", req.getAttribute(ERROR_SERVLET_NAME));
            LOGGER.debug("javax.servlet.error.exception:{}", req.getAttribute(ERROR_EXCEPTION));
            LOGGER.debug("javax.servlet.error.request_uri:{}", req.getAttribute(ERROR_REQUEST_URI));
            LOGGER.debug("org.pageseeder.berlioz.error_id:{}", req.getAttribute(BERLIOZ_ERROR_ID));
        }
        if (ignoreExtensions.contains(ext = ErrorHandlerServlet.getExtension(original = ErrorHandlerServlet.getOriginalURI(req)))) {
            res.reset();
            res.setStatus(code);
            res.setContentType("text/plain;charset=UTF-8");
            ServletOutputStream o = res.getOutputStream();
            o.close();
            res.setIntHeader("Content-Length", 0);
            res.flushBuffer();
            return;
        }
        if (uri.endsWith(autoExtension)) {
            if (!forwardExtensions.contains(ext)) {
                ext = defaultExtension;
            }
            String to = ErrorHandlerServlet.replaceAutoURI(uri, ext, req.getContextPath());
            if (!uri.equals(to = Paths.get(to, new String[0]).normalize().toString())) {
                RequestDispatcher dispatcher = req.getRequestDispatcher(to);
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                return;
            }
        }
        String xml = ErrorHandlerServlet.toXML(req);
        res.reset();
        res.setCharacterEncoding("utf-8");
        res.setStatus(code);
        PrintWriter out = res.getWriter();
        ClassLoader loader = ErrorHandlerServlet.class.getClassLoader();
        URL url = loader.getResource("org/pageseeder/berlioz/xslt/failsafe-error-html.xsl");
        if (url != null) {
            String html = XSLTransformer.transformFailSafe(xml, url);
            res.setContentType("text/html;charset=UTF-8");
            out.print(html);
            out.flush();
        } else {
            res.setContentType("application/xml;charset=UTF-8");
            out.print(xml);
            out.flush();
        }
    }

    private static String toXML(HttpServletRequest req) {
        String message = (String)req.getAttribute(ERROR_MESSAGE);
        int code = ErrorHandlerServlet.getErrorCode((ServletRequest)req);
        String servlet = (String)req.getAttribute(ERROR_SERVLET_NAME);
        Throwable throwable = ErrorHandlerServlet.getErrorException((ServletRequest)req);
        String requestURI = (String)req.getAttribute(ERROR_REQUEST_URI);
        String errorId = (String)req.getAttribute(BERLIOZ_ERROR_ID);
        StringWriter out = new StringWriter();
        try {
            ErrorID eid;
            XMLWriterImpl xml = new XMLWriterImpl((Writer)out, true);
            xml.xmlDecl();
            xml.openElement(ErrorHandlerServlet.getRootElementName(code));
            xml.attribute("http-code", code);
            xml.attribute("datetime", ISO8601.format(System.currentTimeMillis(), ISO8601.DATETIME));
            ErrorID errorID = eid = throwable instanceof BerliozException ? ((BerliozException)throwable).id() : null;
            if (eid != null) {
                xml.attribute("id", eid.id());
            } else {
                xml.attribute("id", errorId != null ? errorId : BerliozErrorID.UNEXPECTED.toString());
            }
            xml.openElement("berlioz");
            xml.attribute("version", GlobalSettings.getVersion());
            xml.closeElement();
            String title = HttpStatusCodes.getTitle(code);
            xml.element("title", title != null ? title : "Berlioz Status");
            xml.element("message", message);
            xml.element("request-uri", requestURI != null ? requestURI : req.getRequestURI());
            xml.element("servlet", servlet != null ? servlet : "null");
            if (throwable != null) {
                Errors.toXML(throwable, (XMLWriter)xml, true);
                if (throwable instanceof CompoundBerliozException) {
                    xml.openElement("collected-errors");
                    ErrorCollector<? extends Throwable> collector = ((CompoundBerliozException)throwable).getCollector();
                    for (CollectedError<? extends Throwable> collected : collector.getErrors()) {
                        collected.toXML((XMLWriter)xml);
                    }
                    xml.closeElement();
                }
            }
            xml.openElement("http-headers");
            Enumeration names = req.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                Enumeration values = req.getHeaders(name);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    String value = values.nextElement().toString();
                    xml.openElement("header");
                    xml.attribute("name", name);
                    xml.attribute("value", value);
                    xml.closeElement();
                }
            }
            xml.closeElement();
            xml.openElement("http-parameters");
            Map parameters = req.getParameterMap();
            for (Map.Entry entry : parameters.entrySet()) {
                String name = entry.getKey().toString();
                String[] values = (String[])entry.getValue();
                if (values == null) continue;
                for (String value : values) {
                    xml.openElement("parameters");
                    xml.attribute("name", name);
                    xml.attribute("value", value);
                    xml.closeElement();
                }
            }
            xml.closeElement();
            xml.closeElement();
            xml.flush();
        }
        catch (IOException io) {
            LOGGER.warn("Unable to produce error details for error below:");
            LOGGER.error("An error occurred while transforming content", throwable);
        }
        return out.toString();
    }

    private static String toJSON(HttpServletRequest req) {
        ErrorID eid;
        String message = (String)req.getAttribute(ERROR_MESSAGE);
        int code = ErrorHandlerServlet.getErrorCode((ServletRequest)req);
        String servlet = (String)req.getAttribute(ERROR_SERVLET_NAME);
        Throwable throwable = ErrorHandlerServlet.getErrorException((ServletRequest)req);
        String requestURI = (String)req.getAttribute(ERROR_REQUEST_URI);
        String errorId = (String)req.getAttribute(BERLIOZ_ERROR_ID);
        StringBuilder json = new StringBuilder();
        json.append('{');
        ErrorHandlerServlet.appendJSONProperty(json, "http-code", code).append(',');
        ErrorHandlerServlet.appendJSONProperty(json, "datetime", ISO8601.format(System.currentTimeMillis(), ISO8601.DATETIME)).append(',');
        ErrorID errorID = eid = throwable instanceof BerliozException ? ((BerliozException)throwable).id() : null;
        if (eid != null) {
            ErrorHandlerServlet.appendJSONProperty(json, "id", eid.id()).append(',');
        } else {
            ErrorHandlerServlet.appendJSONProperty(json, "id", errorId != null ? errorId : BerliozErrorID.UNEXPECTED.toString()).append(',');
        }
        ErrorHandlerServlet.appendJSONName(json, "berlioz");
        json.append('{');
        ErrorHandlerServlet.appendJSONProperty(json, "version", GlobalSettings.getVersion());
        json.append('}');
        json.append(',');
        String title = HttpStatusCodes.getTitle(code);
        ErrorHandlerServlet.appendJSONProperty(json, "title", title != null ? title : "Berlioz Status").append(',');
        ErrorHandlerServlet.appendJSONProperty(json, "message", message).append(',');
        ErrorHandlerServlet.appendJSONProperty(json, "request-uri", requestURI != null ? requestURI : req.getRequestURI()).append(',');
        ErrorHandlerServlet.appendJSONProperty(json, "servlet", servlet != null ? servlet : "null").append(',');
        ErrorHandlerServlet.appendJSONName(json, "http-headers");
        json.append('[');
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Enumeration values = req.getHeaders(name);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = values.nextElement().toString();
                json.append('{');
                ErrorHandlerServlet.appendJSONProperty(json, "name", name);
                json.append(',');
                ErrorHandlerServlet.appendJSONProperty(json, "value", value);
                json.append('}');
            }
        }
        json.append(']');
        json.append(',');
        ErrorHandlerServlet.appendJSONName(json, "http-parameters");
        json.append('[');
        Map parameters = req.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            String name = entry.getKey().toString();
            String[] values = (String[])entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                json.append('{');
                ErrorHandlerServlet.appendJSONProperty(json, "name", name);
                json.append(',');
                ErrorHandlerServlet.appendJSONProperty(json, "value", value);
                json.append('}');
            }
        }
        json.append(']');
        json.append('}');
        return json.toString();
    }

    private static String getRootElementName(Integer code) {
        String element = HttpStatusCodes.getClassOfStatus(code);
        return element != null ? element.toLowerCase().replace(' ', '-') : "unknown-status";
    }

    private static String getExtension(String uri) {
        int dot = uri.lastIndexOf(46);
        return dot >= 0 ? uri.substring(dot) : "";
    }

    private static String getOriginalURI(HttpServletRequest req) {
        Object original = req.getAttribute(ERROR_REQUEST_URI);
        if (original instanceof String) {
            return (String)original;
        }
        return req.getRequestURI();
    }

    private static int getErrorCode(ServletRequest req) {
        Object o = req.getAttribute(ERROR_STATUS_CODE);
        if (o == null) {
            return 200;
        }
        if (o instanceof Integer) {
            Integer code = (Integer)o;
            return code;
        }
        LOGGER.error("The 'javax.servlet.error.status_code' must contain an Integer, but was of type: {}", (Object)o.getClass().getSimpleName());
        return 500;
    }

    private static @Nullable Throwable getErrorException(ServletRequest req) {
        Object o = req.getAttribute(ERROR_EXCEPTION);
        if (o == null) {
            return null;
        }
        if (o instanceof Throwable) {
            return (Throwable)o;
        }
        LOGGER.error("The 'javax.servlet.error.exception' must contain a Throwable, but was of type: {}", (Object)o.getClass().getSimpleName());
        return null;
    }

    private static String replaceAutoURI(String uri, String ext, String context) {
        String to = uri.substring(context.length());
        int dot = to.lastIndexOf(46);
        to = (dot >= 0 ? to.substring(0, dot) : uri) + ext;
        LOGGER.debug("Auto forward: {} to {}", (Object)uri, (Object)to);
        return to;
    }

    private static StringBuilder appendJSONName(StringBuilder json, String name) {
        return json.append('\"').append(name).append('\"').append(':');
    }

    private static StringBuilder appendJSONProperty(StringBuilder json, String name, String value) {
        json.append('\"').append(name).append('\"').append(':');
        json.append('\"').append(value).append('\"');
        return json;
    }

    private static StringBuilder appendJSONProperty(StringBuilder json, String name, int value) {
        return json;
    }
}

