/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.content.MatchingService;
import org.pageseeder.berlioz.content.ServiceLoader;
import org.pageseeder.berlioz.content.ServiceRegistry;
import org.pageseeder.berlioz.http.HttpHeaderUtils;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.berlioz.http.ServerTimingHeader;
import org.pageseeder.berlioz.servlet.BerliozConfig;
import org.pageseeder.berlioz.servlet.BerliozOutput;
import org.pageseeder.berlioz.servlet.ErrorHandlerServlet;
import org.pageseeder.berlioz.servlet.HttpRequestWrapper;
import org.pageseeder.berlioz.servlet.XMLContent;
import org.pageseeder.berlioz.servlet.XMLResponse;
import org.pageseeder.berlioz.servlet.XSLTransformResult;
import org.pageseeder.berlioz.servlet.XSLTransformer;
import org.pageseeder.berlioz.util.CharsetUtils;
import org.pageseeder.berlioz.util.EntityInfo;
import org.pageseeder.berlioz.util.MD5;
import org.pageseeder.berlioz.util.ProfileFormat;
import org.pageseeder.berlioz.util.ResourceCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BerliozServlet
extends HttpServlet {
    private static final long serialVersionUID = 2010071926180001L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BerliozServlet.class);
    private transient @Nullable BerliozConfig berliozConfig;
    private transient @Nullable ServiceRegistry serviceRegistry;
    private transient @Nullable RequestDispatcher errorHandler;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.berliozConfig = BerliozConfig.newConfig(servletConfig);
        this.serviceRegistry = ServiceLoader.getInstance().getDefaultRegistry();
        this.errorHandler = servletConfig.getServletContext().getNamedDispatcher("ErrorHandlerServlet");
        if (this.errorHandler == null) {
            LOGGER.info("No ErrorHandlerServlet is defined in the Web descriptor");
            LOGGER.info("Berlioz will use the fail safe error handler instead");
        }
    }

    public void destroy() {
        super.destroy();
        LOGGER.info("Destroying Berlioz Servlet");
        BerliozConfig.unregister(this.getBerliozConfig());
        this.berliozConfig = null;
        this.serviceRegistry = null;
        this.errorHandler = null;
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            HttpMethod method = HttpMethod.valueOf(req.getMethod());
            if (method == HttpMethod.OPTIONS) {
                this.doOptions(req, res);
            } else {
                this.process(req, res, method, method != HttpMethod.HEAD);
            }
        }
        catch (IllegalArgumentException ex) {
            this.sendError(req, res, 501, "Unsupported HTTP method", null);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(req, res, HttpMethod.HEAD, false);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(req, res, HttpMethod.GET, true);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(req, res, HttpMethod.POST, true);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(req, res, HttpMethod.PUT, true);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(req, res, HttpMethod.DELETE, true);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) {
        ServiceRegistry services = this.getServiceRegistry();
        String path = HttpRequestWrapper.getBerliozPath(req);
        List<String> methods = services.allows(path);
        res.setHeader("Allow", HttpHeaderUtils.allow(methods));
    }

    private void process(HttpServletRequest req, HttpServletResponse res, HttpMethod method, boolean includeContent) throws ServletException, IOException {
        boolean isCompressed;
        BerliozOutput result;
        boolean cacheable;
        BerliozConfig config = this.getBerliozConfig();
        ServiceRegistry services = this.getServiceRegistry();
        req.setCharacterEncoding("utf-8");
        res.setContentType(config.getContentType());
        if (req.getHeader("Range") != null) {
            res.setHeader("Accept-Ranges", "none");
        }
        ServiceLoader loader = ServiceLoader.getInstance();
        boolean profile = GlobalSettings.has(BerliozOption.PROFILE);
        boolean serverTiming = GlobalSettings.has(BerliozOption.HTTP_SERVER_TIMING);
        boolean serviceHeader = GlobalSettings.has(BerliozOption.HTTP_SERVICE_HEADER);
        if (config.hasControl(req)) {
            boolean clearServices;
            boolean resetEtags;
            boolean clearCache;
            boolean reload = this.isTrue(req.getParameter("berlioz-reload"));
            boolean bl = clearCache = reload || this.isTrue(req.getParameter("clear-xsl-cache"));
            if (clearCache) {
                XSLTransformer.clearAllCache();
            }
            boolean bl2 = resetEtags = reload || this.isTrue(req.getParameter("reset-etags"));
            if (resetEtags) {
                config.resetETagSeed();
            }
            if (reload) {
                GlobalSettings.load();
            }
            boolean bl3 = clearServices = reload || this.isTrue(req.getParameter("reload-services"));
            if (clearServices) {
                loader.clear();
            }
            profile = profile || this.isTrue(req.getParameter("berlioz-profile"));
        }
        try {
            long beforeLoad = System.nanoTime();
            boolean loaded = loader.loadIfRequired();
            if (loaded && serverTiming) {
                ServerTimingHeader.addMetricNano(res, "load", "Loading services", System.nanoTime() - beforeLoad);
            }
        }
        catch (BerliozException ex) {
            this.sendError(req, res, 503, "Service configuration Error", ex);
            return;
        }
        String path = HttpRequestWrapper.getBerliozPath(req);
        MatchingService match = services.get(path, method);
        if (match == null && method == HttpMethod.POST && GlobalSettings.has(BerliozOption.HTTP_GET_VIA_POST)) {
            match = services.get(path, HttpMethod.GET);
        }
        if (match == null) {
            List<String> methods;
            if (method != HttpMethod.HEAD && method != HttpMethod.GET && (methods = services.allows(path)).size() > 0) {
                res.setHeader("Allow", HttpHeaderUtils.allow(methods));
                String message = "Only the following are allowed: " + HttpHeaderUtils.allow(methods);
                this.sendError(req, res, 405, message, null);
                return;
            }
            this.sendError(req, res, 404, "Unable to find " + req.getRequestURI(), null);
            LOGGER.debug("No matching service for: {}", (Object)req.getRequestURI());
            return;
        }
        XMLResponse xml = new XMLResponse(req, res, config, match, profile);
        if (serverTiming) {
            xml.enableServerTiming();
        }
        if (serviceHeader) {
            res.setHeader("X-Berlioz-Service", BerliozServlet.toSafeHeader(match.service().id()));
        }
        LOGGER.debug("{} -> {}", (Object)path, (Object)match.service());
        Integer code = (Integer)req.getAttribute("javax.servlet.error.status_code");
        XSLTransformer transformer = config.getTransformer(match.service());
        long start = System.nanoTime();
        if (config.enableCompression()) {
            res.setHeader("Vary", "Accept-Encoding");
        }
        String etag = null;
        boolean bl = cacheable = code == null && match.isCacheable();
        if (cacheable && (method == HttpMethod.GET || method == HttpMethod.HEAD)) {
            String etagXML = xml.getEtag();
            if (etagXML != null) {
                String etagXSL = transformer != null ? transformer.getEtag() : null;
                etag = '\"' + MD5.hash(config.getETagSeed() + "~" + etagXML + "--" + etagXSL) + '\"';
                res.setDateHeader("Expires", config.getExpiryDate());
                String cc = xml.getService().cache();
                if (cc.isEmpty()) {
                    cc = config.getCacheControl();
                }
                res.setHeader("Cache-Control", BerliozServlet.toSafeHeader(cc));
                res.setHeader("ETag", etag);
                ServiceInfo info = new ServiceInfo(etag);
                if (!HttpHeaderUtils.checkIfHeaders(req, res, info)) {
                    return;
                }
            } else {
                cacheable = false;
            }
        }
        if (!cacheable) {
            res.setDateHeader("Expires", 0L);
            res.setHeader("Cache-Control", "no-cache");
        }
        String content = xml.generate();
        long end = System.nanoTime();
        if (profile) {
            LOGGER.info("Content generated in {} ms", (Object)ProfileFormat.format(end - start));
        }
        if (serverTiming) {
            ServerTimingHeader.addMetricNano(res, "xml", "XML Response", end - start);
        }
        ContentStatus status = xml.getStatus();
        if (code != null) {
            res.setStatus(code.intValue());
        } else {
            res.setStatus(status.code());
        }
        if (xml.getError() != null && !GlobalSettings.has(BerliozOption.ERROR_GENERATOR_CATCH)) {
            this.sendError(req, res, status.code(), "The service failed because of errors thrown by generators", xml.getError());
            return;
        }
        if (ContentStatus.isRedirect(status)) {
            String url = xml.getRedirectURL();
            LOGGER.debug("Redirecting to: {} with {}", (Object)url, (Object)status.code());
            res.reset();
            res.sendRedirect(url);
            res.setStatus(status.code());
            return;
        }
        if (transformer != null) {
            XSLTransformResult xslresult = transformer.transform(content, req, xml.getService());
            if (profile) {
                LOGGER.info("XSLT Transformation {} ms", (Object)ProfileFormat.format(xslresult.time()));
            }
            if (serverTiming) {
                ServerTimingHeader.addMetricNano(res, "xslt", "XSLT Transform", xslresult.time());
            }
            result = xslresult;
            if (xslresult.status() == XSLTransformResult.Status.ERROR) {
                res.reset();
                res.setStatus(503);
            }
        } else {
            result = new XMLContent(content);
        }
        String ctype = result.getMediaType() + ";charset=" + result.getEncoding();
        res.setContentType(ctype);
        res.setCharacterEncoding(result.getEncoding());
        if (!config.getContentType().equals(ctype)) {
            LOGGER.info("Updating content type to {}", (Object)ctype);
            config.setContentType(ctype);
        }
        boolean bl4 = isCompressed = config.enableCompression() && HttpHeaderUtils.isCompressible(result.getMediaType());
        if (isCompressed) {
            if (HttpHeaderUtils.acceptsGZipCompression(req)) {
                byte[] compressed = ResourceCompressor.compress(result.content(), Charset.forName(result.getEncoding()));
                if (compressed.length > 0) {
                    res.setIntHeader("Content-Length", compressed.length);
                    res.setHeader("Content-Encoding", "gzip");
                    if (etag != null) {
                        res.setHeader("ETag", HttpHeaderUtils.getETagForGZip(etag));
                    }
                    if (includeContent) {
                        ServletOutputStream out = res.getOutputStream();
                        out.write(compressed);
                        out.flush();
                    }
                } else {
                    isCompressed = false;
                }
            } else {
                isCompressed = false;
            }
        }
        if (!isCompressed) {
            if (includeContent) {
                PrintWriter out = res.getWriter();
                out.print(result.content());
                out.flush();
            } else {
                res.setIntHeader("Content-Length", CharsetUtils.length(result.content(), Charset.forName(result.getEncoding())));
            }
        }
    }

    private void sendError(HttpServletRequest req, HttpServletResponse res, int code, String message, @Nullable Exception ex) throws IOException, ServletException {
        Integer error = (Integer)req.getAttribute("javax.servlet.error.status_code");
        if (error != null || GlobalSettings.has(BerliozOption.ERROR_HANDLER)) {
            RequestDispatcher handler;
            req.setAttribute("javax.servlet.error.status_code", (Object)(error != null ? error : code));
            req.setAttribute("javax.servlet.error.message", (Object)message);
            req.setAttribute("javax.servlet.error.request_uri", (Object)req.getRequestURI());
            req.setAttribute("javax.servlet.error.servlet_name", (Object)this.getBerliozConfig().getName());
            if (ex != null) {
                req.setAttribute("javax.servlet.error.exception", (Object)ex);
                req.setAttribute("javax.servlet.error.exception_type", ex.getClass());
            }
            if ((handler = this.errorHandler) != null) {
                String format = "Berlioz forwarding error {} [{}] to handler";
                if (code >= 500) {
                    LOGGER.error(format, new Object[]{message, code, ex});
                } else {
                    LOGGER.warn(format, new Object[]{message, code, ex});
                }
                handler.forward((ServletRequest)req, (ServletResponse)res);
            } else {
                String format = "Berlioz handling error {} [{}] to handler";
                if (code >= 500) {
                    LOGGER.error(format, new Object[]{message, code, ex});
                } else {
                    LOGGER.warn(format, new Object[]{message, code, ex});
                }
                ErrorHandlerServlet.handle(req, res);
            }
        } else {
            String format = "Berlioz sending error to Web container {} [{}] to handler";
            if (code >= 500) {
                LOGGER.error(format, new Object[]{message, code, ex});
            } else {
                LOGGER.warn(format, new Object[]{message, code, ex});
            }
            res.sendError(code, req.getRequestURI());
        }
    }

    private boolean isTrue(@Nullable String parameter) {
        return "true".equals(parameter);
    }

    private BerliozConfig getBerliozConfig() {
        return Objects.requireNonNull(this.berliozConfig, "Berlioz is not configured!");
    }

    private ServiceRegistry getServiceRegistry() {
        return Objects.requireNonNull(this.serviceRegistry, "Berlioz services are not configured!");
    }

    private static String toSafeHeader(String value) {
        return value.replaceAll("[\\r\\n]", " ");
    }

    private static final class ServiceInfo
    implements EntityInfo {
        private final String _etag;

        public ServiceInfo(String etag) {
            this._etag = etag;
        }

        @Override
        public @NonNull String getETag() {
            return this._etag;
        }

        @Override
        public @NonNull String getMimeType() {
            return "text/html";
        }

        @Override
        public long getLastModified() {
            return -1L;
        }
    }
}

