/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.content.Environment;
import org.pageseeder.berlioz.content.GeneratorListener;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.servlet.HttpEnvironment;
import org.pageseeder.berlioz.servlet.XMLResponse;
import org.pageseeder.berlioz.servlet.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BerliozConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BerliozConfig.class);
    private static final Map<String, BerliozConfig> CONFIGS = new ConcurrentHashMap<String, BerliozConfig>();
    private static final Random RANDOM = new Random();
    private final ServletConfig _servletConfig;
    private String _contentType;
    private final String _cacheControl;
    private final String _controlKey;
    private final String _stylePath;
    private final String _fallbackStyleSheet;
    private final boolean _compression;
    private final Environment _env;
    private final TransformAllocation _allocation;
    private final Map<String, XSLTransformer> _transformers;
    private volatile long etagSeed;

    private BerliozConfig(ServletConfig servletConfig) {
        String cacheControl;
        this._servletConfig = servletConfig;
        ServletContext context = servletConfig.getServletContext();
        File contextPath = new File(context.getRealPath("/"));
        File webinfPath = new File(contextPath, "WEB-INF");
        this._stylePath = this.getInitParameter("stylesheet", "IDENTITY");
        this._allocation = BerliozConfig.toAllocation(this._stylePath);
        this._fallbackStyleSheet = this.getInitParameter("fallback-stylesheet", "");
        this._transformers = this._allocation != TransformAllocation.NIL ? new ConcurrentHashMap() : Collections.emptyMap();
        this._contentType = this.getInitParameter("content-type", "text/html;charset=utf-8");
        if ("IDENTITY".equals(this._stylePath) && !this._contentType.contains("xml")) {
            LOGGER.warn("Servlet {} specified content type {} but output is XML", (Object)servletConfig.getServletName(), (Object)this._contentType);
        }
        if ((cacheControl = GlobalSettings.get(BerliozOption.HTTP_CACHE_CONTROL)).isEmpty()) {
            cacheControl = "no-cache";
        }
        this._cacheControl = this.getInitParameter("cache-control", cacheControl);
        this._controlKey = this.getInitParameter("berlioz-control", GlobalSettings.get(BerliozOption.XML_CONTROL_KEY));
        this._compression = this.getInitParameter("http-compression", GlobalSettings.has(BerliozOption.HTTP_COMPRESSION));
        this._env = new HttpEnvironment(contextPath, webinfPath, this._cacheControl);
        this.etagSeed = this.getEtagSeed();
    }

    public String getName() {
        return this._servletConfig.getServletName();
    }

    public Environment getEnvironment() {
        return this._env;
    }

    public long getETagSeed() {
        return this.etagSeed;
    }

    public void resetETagSeed() {
        this.etagSeed = this.newEtagSeed();
    }

    public long getExpiryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(1, 1);
        return calendar.getTimeInMillis();
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public String getContentType() {
        return this._contentType;
    }

    public boolean enableCompression() {
        return this._compression;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public boolean hasControl(HttpServletRequest req) {
        return BerliozConfig.hasControl(req, this._controlKey);
    }

    public static boolean hasControl(HttpServletRequest req, @Nullable String controlKey) {
        if (controlKey == null || "".equals(controlKey)) {
            return true;
        }
        if (controlKey.equals(req.getParameter("berlioz-control"))) {
            return true;
        }
        @Nullable Enumeration e = req.getHeaders("Authorization");
        if (e != null) {
            while (e.hasMoreElements()) {
                String auth = (String)e.nextElement();
                if (!auth.startsWith("Berlioz ") || !auth.endsWith(controlKey)) continue;
                return true;
            }
        }
        return false;
    }

    public @Nullable XSLTransformer getTransformer(Service service) {
        switch (this._allocation) {
            case NIL: {
                return null;
            }
            case GLOBAL: {
                return this.getTransformer(service, "global");
            }
            case GROUP: {
                return this.getTransformer(service, service.group());
            }
            case SERVICE: {
                return this.getTransformer(service, service.id());
            }
        }
        return null;
    }

    public static synchronized BerliozConfig newConfig(ServletConfig servletConfig) {
        BerliozConfig config = new BerliozConfig(servletConfig);
        String name = servletConfig.getServletName();
        CONFIGS.put(name, config);
        return config;
    }

    public static synchronized boolean unregister(BerliozConfig config) {
        String name = config._servletConfig.getServletName();
        return CONFIGS.remove(name) != null;
    }

    @Beta
    public static synchronized void setListener(GeneratorListener listener) {
        XMLResponse.setListener(listener);
    }

    @Beta
    public static synchronized @Nullable GeneratorListener getListener() {
        return XMLResponse.getListener();
    }

    private String getInitParameter(String name, String def) {
        String value = this._servletConfig.getInitParameter(name);
        return value != null ? value : def;
    }

    private boolean getInitParameter(String name, boolean def) {
        String value = this._servletConfig.getInitParameter(name);
        return value != null ? "true".equals(value) : def;
    }

    private long getEtagSeed() {
        long seed = 0L;
        File f = this._env.getPrivateFile("berlioz.etag");
        if (f.exists() && f.length() < 100L) {
            try (Scanner scanner = new Scanner(f);){
                String etag = scanner.useDelimiter("\\Z").next();
                etag = etag.replaceAll("[^a-zA-Z0-9-]", "");
                seed = Long.parseLong(etag, 36);
                LOGGER.info("Loading the etag seed {}", (Object)etag);
            }
            catch (IOException | NumberFormatException ex) {
                LOGGER.warn("Unable to load the etag seed", (Throwable)ex);
            }
        }
        return seed;
    }

    private long newEtagSeed() {
        long seed = RANDOM.nextLong();
        LOGGER.info("Generating new ETag Seed: {}", (Object)Long.toString(seed, 36));
        File f = this._env.getPrivateFile("berlioz.etag");
        File p = f.getParentFile();
        if (f.exists() && f.canWrite() || p != null && p.canWrite()) {
            try (FileOutputStream os = new FileOutputStream(f);){
                for (char c : Long.toString(seed, 36).toCharArray()) {
                    os.write(c);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to save the etag seed", (Throwable)ex);
            }
        }
        return seed;
    }

    private XSLTransformer getTransformer(Service service, String key) {
        return this._transformers.computeIfAbsent(key, k -> this.newTransformer(service));
    }

    private XSLTransformer newTransformer(Service service) {
        String path = this._stylePath;
        path = path.replaceAll("\\{GROUP}", service.group());
        path = path.replaceAll("\\{SERVICE}", service.id());
        File styleSheet = this._env.getPrivateFile(path);
        return new XSLTransformer(styleSheet, this.toURL(this._fallbackStyleSheet));
    }

    private static TransformAllocation toAllocation(String stylePath) {
        if ("IDENTITY".equals(stylePath) || stylePath == null) {
            return TransformAllocation.NIL;
        }
        if (stylePath.contains("{SERVICE}")) {
            return TransformAllocation.SERVICE;
        }
        if (stylePath.contains("{GROUP}")) {
            return TransformAllocation.GROUP;
        }
        return TransformAllocation.GLOBAL;
    }

    private @Nullable URL toURL(String path) {
        if (path.length() == 0) {
            return null;
        }
        URL url = null;
        if (path.startsWith("resource:")) {
            ClassLoader loader = BerliozConfig.class.getClassLoader();
            url = loader.getResource(path.substring("resource:".length()));
            if (url == null) {
                LOGGER.warn("Unable to load {} as fallback templates", (Object)path);
            }
        } else {
            File file = this._env.getPrivateFile(path);
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Unable to load {} as fallback templates", (Object)path, (Object)ex);
            }
        }
        return url;
    }

    private static enum TransformAllocation {
        NIL,
        GLOBAL,
        GROUP,
        SERVICE;

    }
}

