/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.json;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.pageseeder.berlioz.json.BuiltinJsonWriter;
import org.pageseeder.berlioz.json.GsonJsonWriter;
import org.pageseeder.berlioz.json.J2eeJsonWriter;
import org.pageseeder.berlioz.json.JacksonJsonWriter;
import org.pageseeder.berlioz.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    private static final Logger LOGGER = LoggerFactory.getLogger(Json.class);
    private static volatile JsonProvider provider = JsonProvider.UNKNOWN;

    private Json() {
    }

    public static JsonWriter newWriter(OutputStream out) {
        if (provider == JsonProvider.UNKNOWN) {
            Json.init();
        }
        return provider.newWriter(out);
    }

    public static JsonWriter newWriter(Writer writer) {
        if (provider == JsonProvider.UNKNOWN) {
            Json.init();
        }
        return provider.newWriter(writer);
    }

    public static String camelify(String name) {
        int dash = name.indexOf(45);
        return dash < 0 ? name : Json.camelify(name, dash);
    }

    private static String camelify(String name, int from) {
        StringBuilder sb = new StringBuilder(name);
        for (int i = from; i < sb.length() - 1; ++i) {
            if (sb.charAt(i) != '-') continue;
            sb.deleteCharAt(i);
            sb.replace(i, i + 1, String.valueOf(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }

    public static synchronized void init() {
        LOGGER.debug("Identifying Json provider");
        for (JsonProvider p : JsonProvider.values()) {
            if (!Json.hasClass(p.className())) continue;
            LOGGER.info("Using {} as JSON provider", (Object)p.className());
            provider = p;
            if (p != JsonProvider.BUILTIN) continue;
            LOGGER.warn("No JSON implementation found - falling back on builtin implementation");
        }
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static enum JsonProvider {
        JACKSON("com.fasterxml.jackson.core.JsonGenerator"){

            @Override
            public JsonWriter newWriter(OutputStream out) {
                return JacksonJsonWriter.newInstance(out);
            }

            @Override
            public JsonWriter newWriter(Writer writer) {
                return JacksonJsonWriter.newInstance(writer);
            }
        }
        ,
        GSON("com.google.gson.stream.JsonWriter"){

            @Override
            public JsonWriter newWriter(OutputStream out) {
                return GsonJsonWriter.newInstance(out);
            }

            @Override
            public JsonWriter newWriter(Writer writer) {
                return GsonJsonWriter.newInstance(writer);
            }
        }
        ,
        JSONP("javax.json.stream.JsonGenerator"){

            @Override
            public JsonWriter newWriter(OutputStream out) {
                return J2eeJsonWriter.newInstance(out);
            }

            @Override
            public JsonWriter newWriter(Writer writer) {
                return J2eeJsonWriter.newInstance(writer);
            }
        }
        ,
        BUILTIN("org.pageseeder.berlioz.json.BuiltinJsonWriter"){

            @Override
            public JsonWriter newWriter(OutputStream out) {
                return new BuiltinJsonWriter(new PrintWriter(out));
            }

            @Override
            public JsonWriter newWriter(Writer writer) {
                return new BuiltinJsonWriter(new PrintWriter(writer));
            }
        }
        ,
        UNKNOWN(""){

            @Override
            public JsonWriter newWriter(OutputStream out) {
                throw new UnsupportedOperationException("No JSON provider available!");
            }

            @Override
            public JsonWriter newWriter(Writer writer) {
                throw new UnsupportedOperationException("No JSON provider available!");
            }
        };

        private final String _className;

        private JsonProvider(String className) {
            this._className = className;
        }

        public String className() {
            return this._className;
        }

        public abstract JsonWriter newWriter(OutputStream var1);

        public abstract JsonWriter newWriter(Writer var1);
    }
}

