/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.json;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import javax.json.JsonException;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class J2eeJsonWriter
implements JsonWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(J2eeJsonWriter.class);
    private static @Nullable JsonGeneratorFactory factory = null;
    private boolean[] inObject = new boolean[64];
    private int level = -1;
    private final JsonGenerator _json;

    private J2eeJsonWriter(JsonGenerator json) {
        this._json = json;
    }

    @Override
    public JsonWriter startArray(String name) {
        this.inObject[++this.level] = false;
        this._json.writeStartArray(name);
        return this;
    }

    @Override
    public JsonWriter startArray() {
        this.inObject[++this.level] = false;
        this._json.writeStartArray();
        return this;
    }

    @Override
    public JsonWriter startObject(String name) {
        this.inObject[++this.level] = true;
        this._json.writeStartObject(name);
        return this;
    }

    @Override
    public JsonWriter startObject() {
        this.inObject[++this.level] = true;
        this._json.writeStartObject();
        return this;
    }

    @Override
    public JsonWriter endArray() {
        --this.level;
        this._json.writeEnd();
        return this;
    }

    @Override
    public JsonWriter endObject() {
        --this.level;
        this._json.writeEnd();
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        this._json.writeKey(name);
        return this;
    }

    @Override
    public JsonWriter nullValue(String name) {
        this._json.writeNull(name);
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        this._json.writeNull();
        return this;
    }

    @Override
    public JsonWriter value(double number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JsonWriter value(long number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JsonWriter value(String value) {
        this._json.write(value);
        return this;
    }

    @Override
    public JsonWriter value(boolean number) {
        this._json.write(number);
        return this;
    }

    @Override
    public JsonWriter field(String name, String value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JsonWriter field(String name, boolean value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JsonWriter field(String name, double value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public JsonWriter field(String name, long value) {
        this._json.write(name, value);
        return this;
    }

    @Override
    public boolean inObject() {
        return this.level >= 0 && this.inObject[this.level];
    }

    @Override
    public void close() {
        this._json.close();
    }

    @Override
    public void flush() {
        this._json.flush();
    }

    public static J2eeJsonWriter newInstance(OutputStream out) {
        JsonGenerator json = J2eeJsonWriter.factory().createGenerator(out);
        return new J2eeJsonWriter(json);
    }

    public static J2eeJsonWriter newInstance(Writer writer) {
        JsonGenerator json = J2eeJsonWriter.factory().createGenerator(writer);
        return new J2eeJsonWriter(json);
    }

    protected static synchronized boolean init() {
        try {
            J2eeJsonWriter.factory();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private static synchronized JsonGeneratorFactory factory() {
        JsonGeneratorFactory f = factory;
        if (f == null) {
            factory = f = J2eeJsonWriter.loadFactory();
        }
        return f;
    }

    private static synchronized JsonGeneratorFactory loadFactory() {
        try {
            JsonProvider provider = JsonProvider.provider();
            LOGGER.debug("JSON Provider found using {}", (Object)provider.getClass().getName());
            return provider.createGeneratorFactory(Collections.emptyMap());
        }
        catch (JsonException ex) {
            LOGGER.warn("JSON Provider not found: {}", (Object)ex.getMessage());
            throw new UnsupportedOperationException("Unable to find suitable provider");
        }
    }

    private void push(boolean isObject) {
        ++this.level;
        if (this.level < this.inObject.length) {
            this.inObject[this.level] = isObject;
        } else {
            this.inObject = Arrays.copyOf(this.inObject, this.inObject.length * 2);
        }
    }
}

