/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.http;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.http.HttpAcceptHeader;
import org.pageseeder.berlioz.util.EntityInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpHeaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHeaderUtils.class);
    private static final SimpleDateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private HttpHeaderUtils() {
    }

    public static boolean checkIfHeaders(HttpServletRequest request, HttpServletResponse response, EntityInfo info) throws IOException {
        return HttpHeaderUtils.checkIfMatch(request, response, info) && HttpHeaderUtils.checkIfModifiedSince(request, response, info) && HttpHeaderUtils.checkIfNoneMatch(request, response, info) && HttpHeaderUtils.checkIfUnmodifiedSince(request, response, info);
    }

    protected static boolean checkIfMatch(HttpServletRequest req, HttpServletResponse res, EntityInfo info) throws IOException {
        String eTag = info.getETag();
        String headerValue = req.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken().trim();
                if (currentToken.endsWith("-gzip\"")) {
                    currentToken = currentToken.substring(0, currentToken.length() - 6) + '\"';
                }
                if (!currentToken.equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                res.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected static boolean checkIfModifiedSince(HttpServletRequest req, HttpServletResponse res, EntityInfo info) {
        try {
            long headerValue = req.getDateHeader("If-Modified-Since");
            long lastModified = info.getLastModified();
            if (headerValue != -1L && req.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                res.setStatus(304);
                String etag = info.getETag();
                if (HttpHeaderUtils.isCompressible(info.getMimeType()) && HttpHeaderUtils.acceptsGZipCompression(req)) {
                    etag = HttpHeaderUtils.getETagForGZip(etag);
                }
                res.setHeader("ETag", etag);
                LOGGER.debug("If-Modified-Since check: NOT MODIFIED, etag={}", (Object)etag);
                return false;
            }
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
        return true;
    }

    protected static boolean checkIfNoneMatch(HttpServletRequest req, HttpServletResponse res, EntityInfo info) throws IOException {
        String eTag = info.getETag();
        String headerValue = req.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            boolean isGZIP = false;
            if (!"*".equals(headerValue)) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken().trim();
                    isGZIP = false;
                    if (currentToken.endsWith("-gzip\"")) {
                        currentToken = currentToken.substring(0, currentToken.length() - 6) + '\"';
                        isGZIP = true;
                    }
                    if (!currentToken.equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
                    eTag = isGZIP ? HttpHeaderUtils.getETagForGZip(eTag) : eTag;
                    res.setStatus(304);
                    res.setHeader("ETag", eTag);
                    LOGGER.debug("If-None-Match check: match etag={}", (Object)eTag);
                    return false;
                }
                LOGGER.debug("If-None-Match check: PRECONDITION FAILED, method={}", (Object)req.getMethod());
                res.sendError(412);
                return false;
            }
        }
        return true;
    }

    protected static boolean checkIfUnmodifiedSince(HttpServletRequest req, HttpServletResponse res, EntityInfo info) throws IOException {
        try {
            long lastModified = info.getLastModified();
            long headerValue = req.getDateHeader("If-Unmodified-Since");
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                res.sendError(412);
                LOGGER.debug("If-Unmodified-Since check: PRECONDITION FAILED, last modified: {} >= {}", (Object)lastModified, (Object)headerValue);
                return false;
            }
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
        return true;
    }

    public static boolean acceptsGZipCompression(HttpServletRequest req) {
        String encoding = req.getHeader("Accept-Encoding");
        return HttpAcceptHeader.accepts(encoding, "gzip");
    }

    public static void setContentLength(HttpServletResponse response, long contentLength) {
        if (contentLength < Integer.MAX_VALUE) {
            response.setContentLength((int)contentLength);
        } else {
            response.setHeader("Content-Length", "" + contentLength);
        }
    }

    public static boolean isCompressible(@Nullable String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("text") || contentType.endsWith("xml") || contentType.endsWith("json") || contentType.endsWith("javascript");
    }

    public static @Nullable String getETagForGZip(@Nullable String etag) {
        if (etag == null) {
            return null;
        }
        int q = etag.lastIndexOf("\"");
        return q > 0 ? etag.substring(0, q) + "-gzip\"" : etag;
    }

    public static @Nullable String getETagForUncompressed(@Nullable String etag) {
        if (etag == null) {
            return null;
        }
        int q = etag.lastIndexOf("-gzip\"");
        return q > 0 ? etag.substring(0, q - 6) + '\"' : etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toLastModified(long modified) {
        SimpleDateFormat simpleDateFormat = HTTP_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return HTTP_DATE_FORMAT.format(new Date(modified));
        }
    }

    @Beta
    public static String allow(List<String> methods) {
        StringBuilder allow = new StringBuilder();
        boolean first = true;
        for (String m : methods) {
            if (first) {
                first = false;
            } else {
                allow.append(',');
            }
            allow.append(m);
        }
        return allow.toString();
    }

    static {
        HTTP_DATE_FORMAT.setTimeZone(GMT);
    }
}

