/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.generator;

import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.Cacheable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.content.MatchingService;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.content.ServiceLoader;
import org.pageseeder.berlioz.content.ServiceRegistry;
import org.pageseeder.berlioz.furi.URIPattern;
import org.pageseeder.berlioz.furi.URIResolveResult;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.berlioz.servlet.HttpEnvironment;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class GetMatchingService
implements ContentGenerator,
Cacheable {
    @Override
    public @NonNull String getETag(ContentRequest req) {
        ServiceRegistry registry = ServiceLoader.getInstance().getDefaultRegistry();
        return Long.toString(registry.version());
    }

    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        String url = this.getURL(req, xml);
        HttpMethod method = this.getMethod(req, xml);
        if (url == null || method == null) {
            return;
        }
        ServiceRegistry registry = ServiceLoader.getInstance().getDefaultRegistry();
        MatchingService match = registry.get(url, method);
        if (match != null) {
            xml.openElement("matching-service", true);
            URIPattern pattern = match.pattern();
            xml.openElement("url", true);
            xml.attribute("path", url);
            xml.attribute("pattern", pattern.toString());
            URIResolveResult result = match.result();
            for (String name : result.names()) {
                xml.openElement("parameter", true);
                xml.attribute("name", name);
                Object o = result.get(name);
                xml.attribute("value", o != null ? o.toString() : "");
                xml.closeElement();
            }
            xml.closeElement();
            Service service = match.service();
            List<String> urls = registry.matches(service);
            HttpEnvironment httpEnv = (HttpEnvironment)req.getEnvironment();
            service.toXML(xml, method, urls, httpEnv.getCacheControl());
            xml.closeElement();
        } else {
            xml.emptyElement("no-matching-service");
        }
    }

    private @Nullable HttpMethod getMethod(ContentRequest req, XMLWriter xml) throws IOException {
        String method = req.getParameter("method", "GET");
        try {
            return HttpMethod.valueOf(method);
        }
        catch (IllegalArgumentException ex) {
            xml.openElement("error");
            xml.attribute("type", "client");
            xml.attribute("message", "The specified HTTP method is invalid: " + method);
            xml.closeElement();
            req.setStatus(ContentStatus.BAD_REQUEST);
            return null;
        }
    }

    private @Nullable String getURL(ContentRequest req, XMLWriter xml) throws IOException {
        String url = req.getParameter("url", "");
        if (url.isEmpty()) {
            xml.openElement("error");
            xml.attribute("type", "client");
            xml.attribute("message", "The URL was not specified");
            xml.closeElement();
            req.setStatus(ContentStatus.BAD_REQUEST);
            return null;
        }
        return url;
    }
}

