/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.generator;

import java.io.IOException;
import org.pageseeder.berlioz.BerliozErrorID;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.ErrorID;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.http.HttpStatusCodes;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.CompoundBerliozException;
import org.pageseeder.berlioz.util.ErrorCollector;
import org.pageseeder.berlioz.util.Errors;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetErrorDetails
implements ContentGenerator {
    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        ErrorID berliozId;
        String message = (String)req.getAttribute("javax.servlet.error.message");
        Integer code = (Integer)req.getAttribute("javax.servlet.error.status_code");
        Throwable exception = (Throwable)req.getAttribute("javax.servlet.error.exception");
        String requestURI = (String)req.getAttribute("javax.servlet.error.request_uri");
        String errorId = (String)req.getAttribute("org.pageseeder.berlioz.error_id");
        if (code == null) {
            code = 200;
        }
        xml.openElement("error");
        xml.attribute("http-class", GetErrorDetails.getHTTPClass(code));
        xml.attribute("http-code", code.intValue());
        xml.attribute("datetime", ISO8601.format(System.currentTimeMillis(), ISO8601.DATETIME));
        ErrorID errorID = berliozId = exception instanceof BerliozException ? ((BerliozException)exception).id() : null;
        if (berliozId != null) {
            xml.attribute("id", berliozId.id());
        } else {
            xml.attribute("id", errorId != null ? errorId : BerliozErrorID.UNEXPECTED.toString());
        }
        String title = HttpStatusCodes.getTitle(code);
        xml.element("title", title != null ? title : "Berlioz Status");
        if (message != null) {
            xml.element("message", message);
        }
        if (requestURI != null) {
            xml.element("request-uri", requestURI);
        }
        if (exception != null) {
            Errors.toXML(exception, xml, true);
            if (exception instanceof CompoundBerliozException) {
                xml.openElement("collected-errors");
                ErrorCollector<? extends Throwable> collector = ((CompoundBerliozException)exception).getCollector();
                for (CollectedError<? extends Throwable> collected : collector.getErrors()) {
                    collected.toXML(xml);
                }
                xml.closeElement();
            }
        }
        xml.closeElement();
        ContentStatus status = ContentStatus.forCode(code);
        if (status != null) {
            req.setStatus(status);
        }
    }

    private static String getHTTPClass(Integer code) {
        String element = HttpStatusCodes.getClassOfStatus(code);
        return element != null ? element.toLowerCase().replace(' ', '-') : "unknown-status";
    }
}

