/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class VariableType {
    private static final Pattern VALID_NAME = Pattern.compile("[a-zA-Z0-9][\\w.-]*");
    private final String _name;

    public VariableType(String name) {
        this._name = Objects.requireNonNull(name, "A variable type must have a name, but was null");
        if (!VariableType.isValidName(name)) {
            throw new IllegalArgumentException("The variable name is not valid: " + name);
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        VariableType v = (VariableType)o;
        return this._name.equals(v._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    protected static boolean isValidName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return VALID_NAME.matcher(name).matches();
    }
}

