/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.furi.Matchable;
import org.pageseeder.berlioz.furi.Token;
import org.pageseeder.berlioz.furi.TokenLiteral;
import org.pageseeder.berlioz.furi.URITemplate;

public final class URIPattern
extends URITemplate
implements Matchable {
    private final Pattern _pattern;
    private int score = -1;

    public URIPattern(String template) {
        super(template);
        if (!URIPattern.isMatchable(this)) {
            throw new IllegalArgumentException("Cannot create a URL pattern containing non-matchable tokens.");
        }
        this._pattern = this.computePattern(this.tokens());
    }

    public URIPattern(URITemplate template) {
        super(template);
        if (!URIPattern.isMatchable(template)) {
            throw new IllegalArgumentException("Cannot create a URL pattern from template containing non-matchable tokens.");
        }
        this._pattern = this.computePattern(this.tokens());
    }

    public static boolean isMatchable(URITemplate template) {
        for (Token t : template.tokens()) {
            if (t instanceof Matchable) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean match(String uri) {
        return this._pattern.matcher(uri).matches();
    }

    @Override
    public Pattern pattern() {
        return this._pattern;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return 7 * this._pattern.pattern().hashCode() + 3 * this.toString().hashCode() + 31;
    }

    protected int score() {
        if (this.score < 0) {
            this.score = this.computeScore(this.tokens());
        }
        return this.score;
    }

    private Pattern computePattern(List<Token> tokens) {
        StringBuilder p = new StringBuilder();
        for (Token t : tokens) {
            Matchable mt = (Matchable)((Object)t);
            p.append('(');
            p.append(mt.pattern());
            p.append(')');
        }
        return Pattern.compile(p.toString());
    }

    private int computeScore(List<Token> tokens) {
        int score = 0;
        for (Token t : tokens) {
            if (!(t instanceof TokenLiteral)) continue;
            score += t.expression().length();
        }
        return score;
    }
}

