/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.Map;
import java.util.regex.Pattern;
import org.pageseeder.berlioz.furi.Matchable;
import org.pageseeder.berlioz.furi.Parameters;
import org.pageseeder.berlioz.furi.Token;
import org.pageseeder.berlioz.furi.TokenBase;
import org.pageseeder.berlioz.furi.URICoder;
import org.pageseeder.berlioz.furi.URITemplateSyntaxException;
import org.pageseeder.berlioz.furi.Variable;

public class TokenVariable
extends TokenBase
implements Token,
Matchable {
    private final Variable _var;

    public TokenVariable(String exp) throws URITemplateSyntaxException {
        this(Variable.parse(exp));
    }

    public TokenVariable(Variable var) {
        super('{' + var.toString() + "}");
        this._var = var;
    }

    public Variable getVariable() {
        return this._var;
    }

    @Override
    public String expand(Parameters variables) {
        return URICoder.encode(this._var.value(variables));
    }

    @Override
    public boolean match(String value) {
        return Variable.isValidValue(value);
    }

    @Override
    public Pattern pattern() {
        return Variable.VALID_VALUE;
    }

    @Override
    public boolean resolve(String expanded, Map<Variable, Object> values) {
        values.put(this._var, URICoder.decode(expanded));
        return true;
    }
}

