/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.Beta;

@Beta
public final class ServiceStatusRule {
    private static final String NAME_SELECTOR_PREFIX = "name:";
    private static final String TARGET_SELECTOR_PREFIX = "target:";
    static final ServiceStatusRule DEFAULT_RULE = new ServiceStatusRule(SelectType.NAME, Collections.emptyList(), CodeRule.HIGHEST);
    private final SelectType _use;
    private final List<String> _items;
    private final CodeRule _rule;

    ServiceStatusRule(SelectType use, List<String> items, CodeRule rule) {
        this._use = Objects.requireNonNull(use, "Use is required.");
        this._items = Objects.requireNonNull(items, "List of generators is required.");
        this._rule = Objects.requireNonNull(rule, "Code role is required.");
    }

    public SelectType use() {
        return this._use;
    }

    public List<String> items() {
        return this._items;
    }

    public boolean appliesTo(@Nullable String nameOrTarget) {
        if (this._items.isEmpty()) {
            return true;
        }
        if (nameOrTarget == null) {
            return false;
        }
        return this._items.contains(nameOrTarget);
    }

    public boolean appliesToAll() {
        return this._items.isEmpty();
    }

    public CodeRule rule() {
        return this._rule;
    }

    public String toString() {
        return (Object)((Object)this._use) + ":" + (this._items.isEmpty() ? "*" : this._items) + " " + (Object)((Object)this._rule);
    }

    public static ServiceStatusRule newInstance(String use, @Nullable String rule) {
        List<Object> list;
        CodeRule r = rule != null ? CodeRule.valueOf(rule.toUpperCase()) : CodeRule.HIGHEST;
        SelectType t = use.startsWith(TARGET_SELECTOR_PREFIX) ? SelectType.TARGET : SelectType.NAME;
        String items = Objects.requireNonNull(use, "Parameter use is null.");
        if (items.startsWith(NAME_SELECTOR_PREFIX)) {
            items = items.substring(NAME_SELECTOR_PREFIX.length());
        } else if (items.startsWith(TARGET_SELECTOR_PREFIX)) {
            items = items.substring(TARGET_SELECTOR_PREFIX.length());
        }
        if ("*".equals(items)) {
            list = Collections.emptyList();
        } else {
            list = Arrays.asList(items.split(","));
            for (String string : list) {
                ServiceStatusRule.validate(string);
            }
        }
        return new ServiceStatusRule(t, Collections.unmodifiableList(list), r);
    }

    private static void validate(String item) {
        if (item.isEmpty()) {
            throw new IllegalArgumentException("Named item is empty");
        }
        for (int i = 0; i < item.length(); ++i) {
            char c = item.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.' || c == ':') continue;
            throw new IllegalArgumentException("Item \"" + item + "\" contains an illegal character '" + c + "'");
        }
    }

    @Beta
    public static enum SelectType {
        TARGET,
        NAME;

    }

    @Beta
    public static enum CodeRule {
        FIRST,
        HIGHEST,
        LOWEST;

    }
}

