/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.config.ConfigLoader;
import org.pageseeder.berlioz.config.MovedLocationPattern;
import org.pageseeder.berlioz.furi.URIPattern;
import org.pageseeder.berlioz.servlet.RelocationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public final class RelocationConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelocationFilter.class);
    private final List<MovedLocationPattern> _mapping;

    public RelocationConfig() {
        this._mapping = Collections.emptyList();
    }

    public RelocationConfig(List<MovedLocationPattern> mapping) {
        this._mapping = mapping;
    }

    public @Nullable String relocate(String from) {
        for (MovedLocationPattern pattern : this._mapping) {
            if (!pattern.match(from)) continue;
            return pattern.getTarget(from);
        }
        return null;
    }

    public static RelocationConfig newInstance(File file) throws ConfigException {
        return ConfigLoader.parse(new Handler(), file);
    }

    private static RelocationConfig newInstance(InputStream in) throws ConfigException {
        return ConfigLoader.parse(new Handler(), in);
    }

    public int size() {
        return this._mapping.size();
    }

    public boolean isEmpty() {
        return this._mapping.isEmpty();
    }

    private static class Handler
    extends ConfigLoader.ConfigHandler<RelocationConfig> {
        private List<MovedLocationPattern> patterns;
        private final Set<String> matchingPatterns = new HashSet<String>();

        private Handler() {
        }

        @Override
        public String getSchema() {
            return "relocation-mapping-1.0";
        }

        @Override
        public void startDocument() {
            this.patterns = new ArrayList<MovedLocationPattern>();
            this.matchingPatterns.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ("relocation".equals(localName)) {
                URIPattern from = this.toPattern(atts.getValue("from"));
                URIPattern to = this.toPattern(atts.getValue("to"));
                if (from == null || to == null) {
                    return;
                }
                if (!this.matchingPatterns.add(from.toString())) {
                    LOGGER.warn("URI pattern: {} is mapped twice", (Object)from);
                }
                this.patterns.add(new MovedLocationPattern(from, to));
            }
        }

        private @Nullable URIPattern toPattern(@Nullable String pattern) {
            if (pattern == null) {
                return null;
            }
            try {
                return new URIPattern(pattern);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Unparseable URI pattern: {} - ignored mapping", (Object)pattern);
                return null;
            }
        }

        @Override
        RelocationConfig getConfig() {
            return new RelocationConfig(this.patterns);
        }
    }
}

