/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.config;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.config.ConfigException;
import org.pageseeder.berlioz.config.ConfigLoader;
import org.pageseeder.berlioz.config.MovedLocationPattern;
import org.pageseeder.berlioz.config.RedirectLocation;
import org.pageseeder.berlioz.furi.URIPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public final class RedirectConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedirectConfig.class);
    private final List<RedirectPattern> _patterns;

    public RedirectConfig() {
        this._patterns = Collections.emptyList();
    }

    public RedirectConfig(List<RedirectPattern> patterns) {
        this._patterns = patterns;
    }

    public static RedirectConfig newInstance(File file) throws ConfigException {
        return ConfigLoader.parse(new Handler(), file);
    }

    public static RedirectConfig newInstance(InputStream in) throws ConfigException {
        return ConfigLoader.parse(new Handler(), in);
    }

    public @Nullable RedirectLocation redirect(String from) {
        for (RedirectPattern pattern : this._patterns) {
            if (!pattern.match(from)) continue;
            return pattern.redirect(from);
        }
        return null;
    }

    public int size() {
        return this._patterns.size();
    }

    public boolean isEmpty() {
        return this._patterns.isEmpty();
    }

    private static class RedirectPattern
    extends MovedLocationPattern {
        final boolean permanent;

        public RedirectPattern(URIPattern from, URIPattern to, boolean permanent) {
            super(from, to);
            this.permanent = permanent;
        }

        public boolean isPermanent() {
            return this.permanent;
        }

        public RedirectLocation redirect(String path) {
            if (!this.match(path)) {
                return null;
            }
            String target = this.getTarget(path);
            return new RedirectLocation(path, target, this.permanent);
        }

        public String toString() {
            return "redirect: " + this.from() + " -> " + this.to() + (this.permanent ? " P" : " T");
        }
    }

    private static class Handler
    extends ConfigLoader.ConfigHandler<RedirectConfig> {
        private List<RedirectPattern> patterns = new ArrayList<RedirectPattern>();
        private final Set<String> matchingPatterns = new HashSet<String>();

        private Handler() {
        }

        @Override
        public String getSchema() {
            return "redirect-mapping-1.0";
        }

        @Override
        public void startDocument() {
            this.patterns = new ArrayList<RedirectPattern>();
            this.matchingPatterns.clear();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if ("redirect".equals(localName)) {
                URIPattern from = Handler.toPattern(atts.getValue("from"));
                URIPattern to = Handler.toPattern(atts.getValue("to"));
                if (from == null || to == null) {
                    return;
                }
                if (!this.matchingPatterns.add(from.toString())) {
                    LOGGER.warn("URI pattern: {} is mapped twice", (Object)from);
                }
                boolean isPermanent = "yes".equals(atts.getValue("permanent"));
                RedirectPattern pattern = new RedirectPattern(from, to, isPermanent);
                this.patterns.add(pattern);
                LOGGER.debug("Added pattern: {}", (Object)pattern);
            }
        }

        private static @Nullable URIPattern toPattern(@Nullable String pattern) {
            if (pattern == null) {
                return null;
            }
            try {
                return new URIPattern(pattern);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Unparseable URI pattern: {} - ignored mapping", (Object)pattern);
                return null;
            }
        }

        @Override
        RedirectConfig getConfig() {
            return new RedirectConfig(this.patterns);
        }
    }
}

