/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.berlioz.util.MD5;

public final class WebBundle {
    private final String _name;
    private final String _id;
    private final List<File> _files;
    private final List<File> _imported;
    private boolean _minimized;
    private volatile @Nullable String _etag;

    public WebBundle(String name, List<File> files, boolean minimized) {
        this._name = name;
        this._files = Collections.unmodifiableList(files);
        this._id = WebBundle.id(files);
        this._imported = new ArrayList<File>();
        this._minimized = minimized;
    }

    public String name() {
        return this._name;
    }

    public List<File> files() {
        return this._files;
    }

    public String id() {
        return this._id;
    }

    public void clearImport() {
        this._imported.clear();
    }

    public void addImport(File f) {
        this._imported.add(f);
    }

    public String getETag(boolean refresh) {
        String etag = this._etag;
        if (etag == null || refresh) {
            this._etag = etag = WebBundle.calculateEtag(this._files, this._imported);
        }
        return etag;
    }

    public boolean isFresh() {
        String etag = WebBundle.calculateEtag(this._files, this._imported);
        return etag.equals(this._etag);
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public boolean isCSSMinimizable() {
        for (File f : this._files) {
            if (!f.getName().endsWith(".min.css")) continue;
            return false;
        }
        for (File f : this._imported) {
            if (!f.getName().endsWith(".min.css")) continue;
            return false;
        }
        return true;
    }

    public String getFileName() {
        StringBuilder filename = new StringBuilder(this._name);
        filename.append('-');
        filename.append(ISO8601.CALENDAR_DATE.format(WebBundle.getMostRecent(this._files)));
        String etag = this.getETag(false);
        filename.append('-').append(etag.substring(etag.length() - 8));
        String ext = WebBundle.getExtension(this._files.get(0));
        if (this._minimized) {
            filename.append(".min");
        }
        if (ext != null) {
            filename.append(ext);
        }
        return filename.toString();
    }

    public static String id(List<File> files) {
        StringBuilder id = new StringBuilder();
        for (File f : files) {
            id.append(f.getAbsolutePath());
        }
        return MD5.hash(id.toString());
    }

    private static String calculateEtag(List<File> files, List<File> imported) {
        StringBuilder key = new StringBuilder();
        for (File f : files) {
            WebBundle.appendKey(f, key);
        }
        for (File f : imported) {
            WebBundle.appendKey(f, key);
        }
        return MD5.hash(key.toString());
    }

    private static @Nullable String getExtension(File file) {
        int dot = file.getName().lastIndexOf(46);
        return dot >= 0 ? file.getName().substring(dot) : null;
    }

    private static void appendKey(File f, StringBuilder key) {
        key.append(f.getAbsolutePath());
        key.append(f.length()).append('>');
        key.append(f.lastModified()).append('|');
    }

    private static long getMostRecent(List<File> files) {
        long mostRecent = 0L;
        for (File f : files) {
            if (f.lastModified() <= mostRecent) continue;
            mostRecent = f.lastModified();
        }
        return mostRecent;
    }
}

