/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.pageseeder.berlioz.bundler.Constants;
import org.pageseeder.berlioz.bundler.ParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSSMin {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSMin.class);
    private static final Map<String, String> FONT_WEIGHTS = CSSMin.initFontWeights();

    private static Map<String, String> initFontWeights() {
        HashMap<String, String> weights = new HashMap<String, String>();
        weights.put("normal", "400");
        weights.put("bold", "700");
        weights.put("bolder", "700");
        weights.put("lighter", "100");
        return Collections.unmodifiableMap(weights);
    }

    private CSSMin() {
    }

    static void minimize(File file, OutputStream out) {
        try {
            CSSMin.minimize((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), out);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("Unable to find file", (Throwable)ex);
        }
    }

    static void minimize(Reader input, OutputStream out) {
        CSSMin.minimize(input, new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    public static void minimize(Reader input, PrintWriter min) {
        try {
            StringBuilder buffer = CSSMin.toBuffer(input);
            String comment = CSSMin.stripComments(buffer);
            LOGGER.debug("Parsing and processing selectors.");
            ArrayList<Rule> rules = new ArrayList<Rule>();
            int line = 0;
            int n = 0;
            int j = 0;
            for (int i = 0; i < buffer.length(); ++i) {
                char c = buffer.charAt(i);
                if (j < 0) {
                    throw new ParsingException("Unbalanced braces!", -1, -1);
                }
                if (c == '{') {
                    ++j;
                    continue;
                }
                if (c == '}') {
                    if (--j != 0) continue;
                    try {
                        rules.add(new Rule(buffer.substring(n, i + 1)));
                    }
                    catch (ParsingException ex) {
                        LOGGER.warn(ex.getMessage() + " L:" + line);
                    }
                    n = i + 1;
                    continue;
                }
                if (c != '\n') continue;
                ++line;
            }
            int countRules = 0;
            min.println(comment);
            for (Rule rule : rules) {
                if (countRules % 10 == 0 || rule._subrules.size() > 0) {
                    min.println();
                }
                min.print(rule.toString());
                ++countRules;
            }
            min.println();
            min.close();
            LOGGER.debug("Process completed successfully.");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            LOGGER.error(ex.getMessage());
        }
    }

    private static StringBuilder toBuffer(Reader input) throws IOException {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader br = new BufferedReader(input);){
            String s;
            while ((s = br.readLine()) != null) {
                if (s.trim().length() > 0) {
                    buffer.append(s);
                }
                buffer.append('\n');
            }
        }
        return buffer;
    }

    private static String stripComments(StringBuilder buffer) throws ParsingException {
        int n = 0;
        int k = 0;
        boolean keep = false;
        StringBuilder comments = new StringBuilder();
        while ((n = buffer.indexOf("/*", n)) != -1) {
            int i;
            if (buffer.charAt(n + 2) == '*') {
                keep = true;
            }
            if ((k = buffer.indexOf("*/", n + 2)) == -1) {
                throw new ParsingException("Unterminated comment. Aborting.", -1, -1);
            }
            int s = 0;
            for (i = n; i < k; ++i) {
                if (buffer.charAt(i) != '\n') continue;
                ++s;
            }
            if (keep) {
                comments.append(buffer.substring(n, k + 2));
            }
            buffer.delete(n, k + 2);
            for (i = 0; i < s; ++i) {
                buffer.insert(n, '\n');
            }
            keep = false;
        }
        return CSSMin.cleanComment(comments.toString());
    }

    private static String cleanComment(String comment) {
        StringBuilder clean = new StringBuilder(comment);
        int n = 0;
        while ((n = clean.indexOf("\n * ", n)) != -1) {
            clean.delete(n, n + 3);
        }
        while ((n = clean.indexOf("\n", n)) != -1) {
            clean.delete(n, n + 1);
        }
        return clean.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: ");
            System.out.println("CSSMin [Input file] [Output file]");
            System.out.println("If no output file is specified, stdout will be used.");
            return;
        }
        try {
            File file = new File(args[0]).getCanonicalFile();
            String currentPath = new File(".").getCanonicalPath();
            if (!file.toPath().startsWith(currentPath) || !file.exists() || file.isDirectory()) {
                throw new IllegalArgumentException("Illegal filepath argument");
            }
            CSSMin.minimize(file, (OutputStream)System.out);
        }
        catch (IOException | IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static class Part {
        private final String _value;

        private Part(String value) {
            this._value = value;
        }

        public static Part newPart(String contents, String property) {
            return new Part(Part.simplify(property, " " + contents));
        }

        public static String simplify(String property, String value) {
            String result = value.replaceAll(" !important", "!important");
            result = result.replaceAll("(\\s)(0)(px|em|%|in|cm|mm|pc|pt|ex)", "$1$2");
            if ((result = result.trim()).equals("0 0 0 0")) {
                result = "0";
            } else if (result.equals("0 0 0")) {
                result = "0";
            } else if (result.equals("0 0")) {
                result = "0";
            }
            result = Part.simplifyParameters(result);
            if (property.equals("font-weight")) {
                result = Part.simplifyFontWeights(result);
            }
            result = Part.simplifyQuotesAndCaps(result);
            result = Part.simplifyColourNames(result);
            result = Part.simplifyHexColours(result);
            return result;
        }

        protected static String simplifyParameters(String value) {
            String[] params = value.split(" ");
            if ("\"".equals(params[0]) || "'".equals(params[0])) {
                return value;
            }
            if (params.length == 4 && params[1].equalsIgnoreCase(params[3])) {
                params = Arrays.copyOf(params, 3);
            }
            if (params.length == 3 && params[0].equalsIgnoreCase(params[2])) {
                params = Arrays.copyOf(params, 2);
            }
            if (params.length == 2 && params[0].equalsIgnoreCase(params[1])) {
                params = Arrays.copyOf(params, 1);
            }
            StringBuilder min = new StringBuilder();
            for (String p : params) {
                if (min.length() > 0) {
                    min.append(' ');
                }
                min.append(p);
            }
            return min.toString();
        }

        protected static String simplifyFontWeights(String value) {
            String result = (String)FONT_WEIGHTS.get(value.toLowerCase());
            return result != null ? result : value;
        }

        protected static String simplifyQuotesAndCaps(String value) {
            String result = value;
            if (result.length() > 4 && "url(".equalsIgnoreCase(result.substring(0, 4))) {
                result = result.replaceAll("(?i)url\\(('|\")?(.*?)\\1\\)", "url($2)");
            } else {
                String[] words = result.split("\\s");
                if (words.length == 1) {
                    result = result.toLowerCase().replaceAll("(['\"])?(.*?)\u0001", "$2");
                }
            }
            return result;
        }

        protected static String simplifyColourNames(String value) {
            String lcContents = value.toLowerCase();
            String result = value;
            for (int i = 0; i < Constants.HTML_COLOR_NAMES.length; ++i) {
                if (lcContents.equals(Constants.HTML_COLOR_NAMES[i])) {
                    if (Constants.HTML_COLOR_VALUES[i].length() >= Constants.HTML_COLOR_NAMES[i].length()) break;
                    result = Constants.HTML_COLOR_VALUES[i];
                    break;
                }
                if (!lcContents.equals(Constants.HTML_COLOR_VALUES[i]) || Constants.HTML_COLOR_NAMES[i].length() >= Constants.HTML_COLOR_VALUES[i].length()) continue;
                result = Constants.HTML_COLOR_NAMES[i];
            }
            return result;
        }

        protected static String simplifyHexColours(String value) {
            StringBuffer result = new StringBuffer();
            Pattern pattern = Pattern.compile("#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])");
            Matcher matcher = pattern.matcher(value);
            while (matcher.find()) {
                if (matcher.group(1).equalsIgnoreCase(matcher.group(2)) && matcher.group(3).equalsIgnoreCase(matcher.group(4)) && matcher.group(5).equalsIgnoreCase(matcher.group(6))) {
                    matcher.appendReplacement(result, "#" + matcher.group(1).toLowerCase() + matcher.group(3).toLowerCase() + matcher.group(5).toLowerCase());
                    continue;
                }
                matcher.appendReplacement(result, matcher.group().toLowerCase());
            }
            matcher.appendTail(result);
            return result.toString();
        }

        public String toString() {
            return this._value;
        }
    }

    private static class Property
    implements Comparable<Property> {
        private final String _property;
        private final Part[] _parts;

        public Property(String property) throws ParsingException {
            Part[] theparts;
            String substr;
            ArrayList<String> parts = new ArrayList<String>();
            boolean inquotes = false;
            boolean inbrackets = false;
            int j = 0;
            for (int i = 0; i < property.length(); ++i) {
                if (inquotes) {
                    inquotes = property.charAt(i) != '\"';
                    continue;
                }
                if (inbrackets) {
                    inbrackets = property.charAt(i) != ')';
                    continue;
                }
                if (property.charAt(i) == '\"') {
                    inquotes = true;
                    continue;
                }
                if (property.charAt(i) == '(') {
                    inbrackets = true;
                    continue;
                }
                if (property.charAt(i) != ':') continue;
                substr = property.substring(j, i);
                if (!"".equals(substr.trim()) && substr != null) {
                    parts.add(substr);
                }
                j = i + 1;
            }
            substr = property.substring(j);
            if (!"".equals(substr.trim()) && substr != null) {
                parts.add(substr);
            }
            if (parts.size() < 2) {
                throw new ParsingException("Warning: Incomplete property: " + property, -1, -1);
            }
            this._property = ((String)parts.get(0)).trim().toLowerCase();
            try {
                theparts = this.parseValues(Property.simplifyColours(((String)parts.get(1)).trim().replaceAll(", ", ",")));
            }
            catch (PatternSyntaxException ex) {
                theparts = this.parseValues(((String)parts.get(1)).trim());
            }
            this._parts = theparts;
        }

        public String toString() {
            return this.append(new StringBuilder()).toString();
        }

        public StringBuilder append(StringBuilder min) {
            min.append(this._property).append(":");
            for (Part p : this._parts) {
                min.append(p.toString()).append(",");
            }
            min.deleteCharAt(min.length() - 1);
            min.append(";");
            return min;
        }

        @Override
        public int compareTo(Property other) {
            String thisProp = this._property;
            String thatProp = other._property;
            if (thisProp.charAt(0) == '-') {
                thisProp = thisProp.substring(1);
                thisProp = thisProp.substring(thisProp.indexOf(45) + 1);
            } else if (thisProp.charAt(0) < 'a') {
                thisProp = thisProp.substring(1);
            }
            if (thatProp.charAt(0) == '-') {
                thatProp = thatProp.substring(1);
                thatProp = thatProp.substring(thatProp.indexOf(45) + 1);
            } else if (thatProp.charAt(0) < 'a') {
                thatProp = thatProp.substring(1);
            }
            return thisProp.compareTo(thatProp);
        }

        private Part[] parseValues(String contents) {
            String[] stringArray;
            if (!contents.contains("data:")) {
                stringArray = contents.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = contents;
            }
            String[] parts = stringArray;
            Part[] results = new Part[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                try {
                    results[i] = Part.newPart(parts[i], this._property);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn(ex.getMessage());
                    results[i] = null;
                }
            }
            return results;
        }

        private static String simplifyColours(String contents) {
            StringBuffer newContents = new StringBuffer();
            Pattern pattern = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
            Matcher matcher = pattern.matcher(contents);
            while (matcher.find()) {
                String[] rgbColours;
                StringBuilder hexColour = new StringBuilder("#");
                for (String rgbColour : rgbColours = matcher.group(1).split(",")) {
                    int colourValue = Integer.parseInt(rgbColour);
                    if (colourValue < 16) {
                        hexColour.append("0");
                    }
                    hexColour.append(Integer.toHexString(colourValue));
                }
                matcher.appendReplacement(newContents, hexColour.toString());
            }
            matcher.appendTail(newContents);
            return newContents.toString();
        }
    }

    private static class Rule {
        private final String _selector;
        private final Property[] _properties;
        private final List<Rule> _subrules;

        public Rule(String rule) throws ParsingException {
            String[] parts = rule.split("\\{");
            if (parts.length < 2) {
                throw new ParsingException("Warning: Incomplete selector: " + rule, -1, -1);
            }
            String selector = parts[0].trim();
            this._selector = selector = selector.replaceAll("\\s?(\\+|~|,|=|~=|\\^=|\\$=|\\*=|\\|=|>)\\s?", "$1");
            Property[] properties = new Property[]{};
            List subrules = Collections.emptyList();
            if (parts.length > 2) {
                subrules = new ArrayList();
                parts = rule.split("\\{|}");
                for (int i = 1; i < parts.length; i += 2) {
                    parts[i] = parts[i].trim();
                    if (parts[i].length() <= 0 || i + 1 >= parts.length) continue;
                    parts[i + 1] = parts[i + 1].trim();
                    if (parts[i + 1].length() <= 0) continue;
                    subrules.add(new Rule(parts[i] + "{" + parts[i + 1] + "}"));
                }
            } else {
                String contents = parts[parts.length - 1].trim();
                if (contents.charAt(contents.length() - 1) != '}') {
                    throw new ParsingException("Unterminated selector: " + rule, -1, -1);
                }
                if (contents.length() > 1) {
                    contents = contents.substring(0, contents.length() - 1);
                    properties = this.parseProperties(contents);
                }
            }
            this._subrules = subrules;
            this._properties = properties;
        }

        public String toString() {
            return this.append(new StringBuilder()).toString();
        }

        public StringBuilder append(StringBuilder min) {
            min.append(this._selector).append('{');
            for (Rule s : this._subrules) {
                min.append(s.toString());
            }
            for (Property p : this._properties) {
                p.append(min);
            }
            if (min.charAt(min.length() - 1) == ';') {
                min.deleteCharAt(min.length() - 1);
            }
            min.append('}');
            return min;
        }

        private Property[] parseProperties(String contents) {
            String substr;
            ArrayList<String> parts = new ArrayList<String>();
            boolean inquotes = false;
            boolean inbrackets = false;
            int j = 0;
            for (int i = 0; i < contents.length(); ++i) {
                if (inquotes) {
                    inquotes = contents.charAt(i) != '\"';
                    continue;
                }
                if (inbrackets) {
                    inbrackets = contents.charAt(i) != ')';
                    continue;
                }
                if (contents.charAt(i) == '\"') {
                    inquotes = true;
                    continue;
                }
                if (contents.charAt(i) == '(') {
                    inbrackets = true;
                    continue;
                }
                if (contents.charAt(i) != ';') continue;
                substr = contents.substring(j, i);
                if (!"".equals(substr.trim()) && substr != null) {
                    parts.add(substr);
                }
                j = i + 1;
            }
            substr = contents.substring(j);
            if (!"".equals(substr.trim()) && substr != null) {
                parts.add(substr);
            }
            Property[] results = new Property[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                try {
                    results[i] = new Property((String)parts.get(i));
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    results[i] = null;
                }
            }
            return results;
        }
    }
}

