/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.bundler.BundleConfig;
import org.pageseeder.berlioz.bundler.BundleDefinition;
import org.pageseeder.berlioz.bundler.BundleType;
import org.pageseeder.berlioz.bundler.WebBundleTool;
import org.pageseeder.berlioz.content.Service;

final class BundleInstance
implements Serializable {
    private static final long serialVersionUID = -4507097239658105026L;
    private final String _name;
    private final String[] _paths;
    private final File[] _files;

    private BundleInstance(String name, String[] paths, File root) {
        this._name = name;
        this._paths = paths;
        this._files = new File[paths.length];
        for (int i = 0; i < this._paths.length; ++i) {
            this._files[i] = new File(root, this._paths[i]);
        }
    }

    public String name() {
        return this._name;
    }

    public @Nullable File getBundleFile(BundleConfig config) {
        List<File> files = this.listExistingFiles();
        WebBundleTool bundler = config.bundler();
        File bundle = null;
        try {
            if (config.type() == BundleType.JS) {
                bundle = bundler.bundleScripts(files, this._name, config.minimize());
            } else if (config.type() == BundleType.CSS) {
                bundle = bundler.bundleStyles(files, this._name, config.minimize());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bundle;
    }

    public void addToExistingPaths(List<String> paths) {
        if (paths == null) {
            return;
        }
        for (int i = 0; i < this._files.length; ++i) {
            if (!this._files[i].exists()) continue;
            paths.add(this._paths[i]);
        }
    }

    public List<String> listExistingPaths() {
        return BundleInstance.computePaths(this._paths, this._files);
    }

    public List<File> listExistingFiles() {
        return BundleInstance.computeFiles(this._files);
    }

    public static BundleInstance instantiate(BundleConfig config, BundleDefinition definition, Service service) {
        String name = BundleInstance.replaceTokens(definition.filename(), service);
        int count = definition.paths().length;
        String[] paths = new String[count];
        for (int i = 0; i < count; ++i) {
            paths[i] = BundleInstance.replaceTokens(definition.paths()[i], service);
        }
        return new BundleInstance(name, paths, config.root());
    }

    private static List<String> computePaths(String[] paths, File[] files) {
        if (paths == null) {
            return Collections.emptyList();
        }
        if (paths.length > 1) {
            ArrayList<String> existing = new ArrayList<String>(paths.length);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].exists()) continue;
                existing.add(paths[i]);
            }
            return existing;
        }
        if (paths.length == 1 && files[0].exists()) {
            return Collections.singletonList(paths[0]);
        }
        return Collections.emptyList();
    }

    private static List<File> computeFiles(File[] files) {
        if (files == null) {
            return Collections.emptyList();
        }
        if (files.length > 1) {
            ArrayList<File> existing = new ArrayList<File>(files.length);
            for (File f : files) {
                if (!f.exists()) continue;
                existing.add(f);
            }
            return existing;
        }
        if (files.length == 1 && files[0].exists()) {
            return Collections.singletonList(files[0]);
        }
        return Collections.emptyList();
    }

    private static String replaceTokens(String value, Service service) {
        String out = value;
        while (out.contains("{GROUP}")) {
            out = out.replace("{GROUP}", service.group());
        }
        while (out.contains("{SERVICE}")) {
            out = out.replace("{SERVICE}", service.id());
        }
        return out;
    }

    private static long getMostRecent(List<File> files) {
        long mostRecent = 0L;
        for (File f : files) {
            if (f.lastModified() <= mostRecent) continue;
            mostRecent = f.lastModified();
        }
        return mostRecent;
    }
}

