/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.bundler;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.bundler.BundleDefinition;
import org.pageseeder.berlioz.bundler.BundleInstance;
import org.pageseeder.berlioz.bundler.BundleType;
import org.pageseeder.berlioz.bundler.WebBundleTool;
import org.pageseeder.berlioz.content.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleConfig
implements Serializable {
    private static final long serialVersionUID = 5709906856099064344L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleConfig.class);
    private static final @NonNull String[] DEFAULT_BUNDLE_CONFIG = new String[]{"global", "group", "service"};
    private static final Map<String, BundleDefinition> DEFAULT_JS_BUNDLE = new HashMap<String, BundleDefinition>();
    private static final Map<String, BundleDefinition> DEFAULT_CSS_BUNDLE;
    private static final String DEFAULT_BUNDLED_SCRIPTS = "/script/_/";
    private static final String DEFAULT_BUNDLED_STYLES = "/style/_/";
    private final List<BundleDefinition> _definitions;
    private final Map<String, List<BundleInstance>> _instances = new WeakHashMap<String, List<BundleInstance>>();
    private final BundleType _type;
    private final boolean _minimize;
    private final String _location;
    private final File _root;
    private final WebBundleTool _bundler;

    private BundleConfig(List<BundleDefinition> definitions, BundleType type, boolean minimize, String location, File root) {
        this._definitions = definitions;
        this._type = type;
        this._minimize = minimize;
        this._location = location;
        this._root = root;
        this._bundler = this.initBundler();
    }

    public List<BundleDefinition> definitions() {
        return this._definitions;
    }

    public BundleType type() {
        return this._type;
    }

    public boolean minimize() {
        return this._minimize;
    }

    public String location() {
        return this._location;
    }

    public File root() {
        return this._root;
    }

    public File store() {
        return new File(this._root, this._location);
    }

    public WebBundleTool bundler() {
        return this._bundler;
    }

    public List<File> getBundles(Service service) {
        List<BundleInstance> instances = this.getInstances(service);
        ArrayList<File> files = new ArrayList<File>(instances.size());
        for (BundleInstance instance : instances) {
            File b = instance.getBundleFile(this);
            if (b == null) continue;
            files.add(b);
        }
        return files;
    }

    public long getLastModifiedBundle(Service service) {
        List<BundleInstance> instances = this.getInstances(service);
        long lastModified = 0L;
        for (BundleInstance instance : instances) {
            File bundle = instance.getBundleFile(this);
            if (bundle == null || bundle.lastModified() <= lastModified) continue;
            lastModified = bundle.lastModified();
        }
        return lastModified;
    }

    public List<String> getPaths(Service service) {
        List<BundleInstance> instances = this.getInstances(service);
        ArrayList<String> paths = new ArrayList<String>();
        for (BundleInstance instance : instances) {
            instance.addToExistingPaths(paths);
        }
        return paths;
    }

    public List<BundleInstance> getInstances(Service service) {
        List<BundleInstance> instances = this._instances.get(service.id());
        if (instances == null) {
            instances = this.instantiate(service);
            this._instances.put(service.id(), instances);
        }
        return instances;
    }

    public static BundleConfig newInstance(String name, BundleType type, File root) {
        String lctype = type.name().toLowerCase();
        @NonNull String[] names = BundleConfig.getBundleNames("berlioz." + lctype + "bundler.configs." + name);
        Map<String, BundleDefinition> defaults = BundleType.JS == type ? DEFAULT_JS_BUNDLE : DEFAULT_CSS_BUNDLE;
        List<BundleDefinition> definitions = BundleConfig.loadDefinitions(names, "berlioz." + lctype + "bundler.bundles.", defaults);
        boolean minimize = GlobalSettings.get("berlioz." + lctype + "bundler.minimize", true);
        String defaultLocation = BundleConfig.getDefaultLocation(type);
        String location = GlobalSettings.get("berlioz." + lctype + "bundler.location", defaultLocation);
        File store = new File(root, location);
        if (!store.exists()) {
            store.mkdirs();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading bundle config:{} ({}) => {}", new Object[]{name, type, names});
            LOGGER.debug("Bundler settings minimize:{} location:{}", (Object)minimize, (Object)location);
            for (BundleDefinition d : definitions) {
                LOGGER.debug("Bundle definition:{} -> {} ({})", new Object[]{d.name(), d.filename(), d.paths()});
            }
        }
        return new BundleConfig(definitions, type, minimize, location, root);
    }

    private WebBundleTool initBundler() {
        WebBundleTool bundler = new WebBundleTool(new File(this._root, this._location));
        if (this._type == BundleType.CSS) {
            int threshold = GlobalSettings.get("berlioz.cssbundler.datauris.threshold", 4096);
            bundler.setDataURIThreshold(threshold);
        }
        return bundler;
    }

    private List<BundleInstance> instantiate(Service service) {
        ArrayList<BundleInstance> instances = new ArrayList<BundleInstance>();
        for (BundleDefinition def : this._definitions) {
            BundleInstance instance = BundleInstance.instantiate(this, def, service);
            instances.add(instance);
        }
        return instances;
    }

    private static List<BundleDefinition> loadDefinitions(@NonNull String[] names, String prefix, Map<String, BundleDefinition> defaults) {
        ArrayList<BundleDefinition> bundles = new ArrayList<BundleDefinition>();
        for (String name : names) {
            BundleDefinition bc = defaults.get(name);
            String filename = GlobalSettings.get(prefix + name + ".filename", name);
            String paths = GlobalSettings.get(prefix + name + ".include", GlobalSettings.get(prefix + name, ""));
            if (paths.length() > 0) {
                bc = new BundleDefinition(name, filename, paths);
            }
            if (bc != null) {
                bundles.add(bc);
                continue;
            }
            LOGGER.warn("Bundle '{}' is undefined", (Object)name);
        }
        return bundles;
    }

    private static @NonNull String[] getBundleNames(String property) {
        String names = GlobalSettings.get(property);
        return names != null ? names.split(",") : DEFAULT_BUNDLE_CONFIG;
    }

    private static String getDefaultLocation(BundleType type) {
        return BundleType.JS == type ? DEFAULT_BUNDLED_SCRIPTS : DEFAULT_BUNDLED_STYLES;
    }

    static {
        DEFAULT_JS_BUNDLE.put("global", new BundleDefinition("global", "global", "/script/global.js"));
        DEFAULT_JS_BUNDLE.put("group", new BundleDefinition("group", "{GROUP}", "/script/{GROUP}.js"));
        DEFAULT_JS_BUNDLE.put("service", new BundleDefinition("service", "{SERVICE}", "/script/{GROUP}/{SERVICE}.js"));
        DEFAULT_CSS_BUNDLE = new HashMap<String, BundleDefinition>();
        DEFAULT_CSS_BUNDLE.put("global", new BundleDefinition("global", "global", "/style/global.css"));
        DEFAULT_CSS_BUNDLE.put("group", new BundleDefinition("group", "{GROUP}", "/style/{GROUP}.css"));
        DEFAULT_CSS_BUNDLE.put("service", new BundleDefinition("service", "{SERVICE}", "/style/{GROUP}/{SERVICE}.css"));
    }
}

