/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.pageseeder.berlioz.aeson.BuiltinJSONWriter;
import org.pageseeder.berlioz.aeson.J2EEJSONWriter;
import org.pageseeder.berlioz.aeson.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONWriterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONWriterFactory.class);
    private static final String J2EE_API = "javax.json.stream.JsonGenerator";
    private static volatile int status = 0;

    private JSONWriterFactory() {
    }

    public static JSONWriter newInstance(OutputStream out) {
        if (status == 0) {
            JSONWriterFactory.init();
        }
        if (status == 1) {
            return J2EEJSONWriter.newInstance(out);
        }
        return new BuiltinJSONWriter(new PrintWriter(out));
    }

    public static JSONWriter newInstance(Writer writer) {
        if (status == 0) {
            JSONWriterFactory.init();
        }
        if (status == 1) {
            return J2EEJSONWriter.newInstance(writer);
        }
        return new BuiltinJSONWriter(new PrintWriter(writer));
    }

    public static synchronized void init() {
        LOGGER.debug("Initializing Aeson");
        try {
            Class.forName(J2EE_API);
            LOGGER.info("JSON API found");
            boolean hasProvider = J2EEJSONWriter.init();
            status = hasProvider ? 1 : 2;
        }
        catch (ClassNotFoundException x) {
            LOGGER.warn("JSON API not found - ");
            status = 2;
        }
    }
}

