/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.aeson.JSONState;
import org.pageseeder.berlioz.aeson.JSONWriter;
import org.pageseeder.berlioz.aeson.JSONWriterFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class JSONSerializer
extends DefaultHandler
implements ContentHandler {
    public static final String NS_URI = "http://pageseeder.org/JSON";
    private final JSONWriter json;
    private final JSONState state = new JSONState();
    private final StringBuilder buffer = new StringBuilder();
    private @Nullable Locator locator = null;

    public JSONSerializer() {
        this.json = JSONWriterFactory.newInstance(System.out);
    }

    public JSONSerializer(OutputStream out) {
        this.json = JSONWriterFactory.newInstance(out);
    }

    public JSONSerializer(Writer writer) {
        this.json = JSONWriterFactory.newInstance(writer);
    }

    @Override
    public void startDocument() {
        this.state.pushState();
    }

    @Override
    public void endDocument() {
        this.state.popState();
        this.json.close();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (!this.state.isContext(JSONState.JSONContext.NULL)) {
                if (NS_URI.equals(uri)) {
                    this.handleJSONElement(localName, atts);
                } else {
                    this.handleElement(localName, atts);
                }
            } else {
                this.state.pushState(JSONState.JSONContext.NULL, atts, "");
                this.warning(new SAXParseException("Ignoring element " + qName + " in null context", this.locator));
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            JSONState.JSONContext wasContext = this.state.currentContext();
            String wasName = this.state.currentName();
            this.state.popState();
            if (wasContext != JSONState.JSONContext.NULL) {
                if (NS_URI.equals(uri)) {
                    if ("array".equals(localName) || "object".equals(localName)) {
                        this.json.end();
                    }
                } else if (wasContext == JSONState.JSONContext.VALUE) {
                    String name = this.state.isContext(JSONState.JSONContext.OBJECT) ? wasName : null;
                    String value = this.buffer.toString();
                    JSONState.JSONType type = this.state.getType(localName);
                    this.writeProperty(name, value, type);
                    this.buffer.setLength(0);
                } else {
                    this.json.end();
                }
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        StringBuilder message = new StringBuilder();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int sol = systemId.lastIndexOf(47);
            message.append('[').append(sol != -1 ? systemId.substring(sol + 1) : systemId).append("] ");
        }
        message.append(ex.getMessage());
        if (ex.getLineNumber() != -1) {
            message.append(" at line ").append(ex.getLineNumber());
        }
        if (ex.getColumnNumber() != -1) {
            message.append(" column ").append(ex.getColumnNumber());
        }
        if (ex.getException() != null) {
            message.append("; caused by ").append(ex.getException().getClass().getSimpleName());
            message.append(": ").append(ex.getException().getMessage());
        }
        System.err.println(message);
    }

    @Override
    public void characters(char[] ch, int start, int len) {
        if (this.state.isContext(JSONState.JSONContext.VALUE)) {
            this.buffer.append(ch, start, len);
        }
    }

    @Override
    public void setDocumentLocator(@Nullable Locator locator) {
        this.locator = locator;
    }

    private static boolean filterNamespace(@Nullable String uri) {
        return !NS_URI.equals(uri) && !"http://www.w3.org/2000/xmlns/".equals(uri) && !"http://www.w3.org/XML/1998/namespace".equals(uri);
    }

    private static boolean hasProperty(Attributes atts) {
        int upto = atts.getLength();
        for (int i = 0; i < upto; ++i) {
            if (!JSONSerializer.filterNamespace(atts.getURI(i))) continue;
            return true;
        }
        return false;
    }

    private void handleJSONElement(String localName, Attributes atts) {
        String name = atts.getValue(NS_URI, "name");
        if (name == null) {
            name = localName;
            if (this.state.isContext(JSONState.JSONContext.OBJECT)) {
                this.warning(new SAXParseException("Attribute json:name must be used to specify array/object name", this.locator));
            }
        }
        if ("array".equals(localName)) {
            if (this.state.isContext(JSONState.JSONContext.OBJECT)) {
                this.json.startArray(name);
            } else {
                this.json.startArray();
            }
            this.state.pushState(JSONState.JSONContext.ARRAY, atts, name);
        } else if ("object".equals(localName)) {
            if (this.state.isContext(JSONState.JSONContext.OBJECT)) {
                this.json.startObject(name);
            } else {
                this.json.startObject();
            }
            this.state.pushState(JSONState.JSONContext.OBJECT, atts, name);
            this.handleValuePairs(atts);
        } else if ("null".equals(localName)) {
            if (this.state.isContext(JSONState.JSONContext.ROOT)) {
                this.warning(new SAXParseException("Illegal null as root, substituting for empty object", this.locator));
                this.json.startObject();
                this.json.end();
            } else if (this.state.isContext(JSONState.JSONContext.OBJECT)) {
                this.json.writeNull(name);
            } else {
                this.json.writeNull();
            }
            this.state.pushState(JSONState.JSONContext.NULL, atts, name);
        } else {
            this.state.pushState(JSONState.JSONContext.OBJECT, atts, name);
            this.warning(new SAXParseException("Unknown JSON element:" + localName, this.locator));
        }
    }

    private void handleElement(String localName, Attributes atts) {
        String name = atts.getValue(NS_URI, "name");
        if (this.state.getType(localName) != JSONState.JSONType.DEFAULT) {
            if (JSONSerializer.hasProperty(atts)) {
                this.warning(new SAXParseException("Element " + localName + " is mapped to a property, also has properties!", this.locator));
            }
            if (name == null) {
                name = localName;
            }
            this.state.pushState(JSONState.JSONContext.VALUE, atts, name);
        } else {
            if (this.state.isContext(JSONState.JSONContext.OBJECT)) {
                if (name == null) {
                    name = localName;
                }
                this.json.startObject(name);
            } else {
                if (atts.getValue(NS_URI, "name") != null) {
                    this.warning(new SAXParseException("Attribute json:name is ignored in array/document context", this.locator));
                }
                this.json.startObject();
            }
            this.state.pushState(JSONState.JSONContext.OBJECT, atts, name);
            this.handleValuePairs(atts);
        }
    }

    private void handleValuePairs(Attributes atts) {
        int _upto = atts.getLength();
        for (int i = 0; i < _upto; ++i) {
            if (!JSONSerializer.filterNamespace(atts.getURI(i))) continue;
            String name = Objects.requireNonNull(atts.getLocalName(i));
            String value = Objects.requireNonNull(atts.getValue(i));
            JSONState.JSONType type = this.state.getType(name);
            this.writeProperty(name, value, type);
        }
    }

    private void writeProperty(@Nullable String name, String value, JSONState.JSONType type) {
        switch (type) {
            case NUMBER: {
                this.asNumber(name, value);
                break;
            }
            case BOOLEAN: {
                this.asBoolean(name, value);
                break;
            }
            case NULL: {
                this.asNull(name);
                break;
            }
            default: {
                this.asString(name, value);
            }
        }
    }

    private void asNumber(@Nullable String name, String value) {
        try {
            if (value.indexOf(46) != -1) {
                double number = Double.parseDouble(value);
                if (name != null) {
                    this.json.property(name, number);
                } else {
                    this.json.value(number);
                }
            } else {
                long number = Long.parseLong(value);
                if (name != null) {
                    this.json.property(name, number);
                } else {
                    this.json.value(number);
                }
            }
        }
        catch (NumberFormatException ex) {
            this.asString(name, value);
            this.warning(new SAXParseException("Unable to convert attribute '" + name + "' to a number", this.locator, ex));
        }
    }

    private void asBoolean(@Nullable String name, String value) {
        if ("true".equals(value)) {
            if (name != null) {
                this.json.property(name, true);
            } else {
                this.json.value(true);
            }
        } else if ("false".equals(value)) {
            if (name != null) {
                this.json.property(name, false);
            } else {
                this.json.value(false);
            }
        } else {
            this.asString(name, value);
            this.warning(new SAXParseException("Unable to convert attribute '" + name + "' to a boolean", this.locator));
        }
    }

    private void asNull(@Nullable String name) {
        if (name != null) {
            this.json.writeNull(name);
        } else {
            this.json.writeNull();
        }
    }

    private void asString(@Nullable String name, String value) {
        if (name != null) {
            this.json.property(name, value);
        } else {
            this.json.value(value);
        }
    }
}

