/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.pageseeder.berlioz.aeson.JSONSerializer;

public class JSONResult
extends SAXResult
implements Result {
    public JSONResult() {
        super(new JSONSerializer());
    }

    public JSONResult(OutputStream out) {
        super(new JSONSerializer(out));
    }

    public JSONResult(Writer writer) {
        super(new JSONSerializer(writer));
    }

    public static Result newInstanceIfSupported(Transformer t, StreamResult result) {
        return JSONResult.supports(t) ? JSONResult.newInstance(result) : result;
    }

    public static JSONResult newInstance(StreamResult result) {
        OutputStream out = result.getOutputStream();
        String systemId = result.getSystemId();
        JSONResult json = null;
        if (out != null) {
            json = new JSONResult(out);
        } else {
            Writer writer = result.getWriter();
            if (writer != null) {
                json = new JSONResult(writer);
            } else if (systemId != null) {
                try {
                    File f = new File(URI.create(systemId));
                    FileOutputStream o = new FileOutputStream(f);
                    json = new JSONResult(o);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to write JSON to " + systemId, ex);
                }
            } else {
                json = new JSONResult();
            }
        }
        if (systemId != null) {
            json.setSystemId(systemId);
        }
        return json;
    }

    public static boolean supports(Transformer t) {
        String method = t.getOutputProperty("method");
        String media = t.getOutputProperty("media-type");
        return "xml".equals(method) && "application/json".equals(media);
    }
}

