/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.PrintWriter;
import org.pageseeder.berlioz.aeson.JSONWriter;

final class BuiltinJSONWriter
implements JSONWriter {
    private final PrintWriter _json;
    private boolean first = true;
    private char[] c = new char[32];
    private int level = -1;

    public BuiltinJSONWriter(PrintWriter json) {
        this._json = json;
    }

    @Override
    public JSONWriter startArray(String name) {
        this.c[++this.level] = 93;
        this.maybeAppendComma(true);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append('[');
        return this;
    }

    @Override
    public JSONWriter startArray() {
        this.c[++this.level] = 93;
        this.maybeAppendComma(true);
        this._json.append('[');
        return this;
    }

    @Override
    public JSONWriter startObject(String name) {
        this.c[++this.level] = 125;
        this.maybeAppendComma(true);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append('{');
        return this;
    }

    @Override
    public JSONWriter startObject() {
        this.c[++this.level] = 125;
        this.maybeAppendComma(true);
        this._json.append('{');
        return this;
    }

    @Override
    public JSONWriter end() {
        if (this.level < 0) {
            throw new IllegalStateException("Nothing to end!");
        }
        this._json.append(this.c[this.level--]);
        this.first = false;
        return this;
    }

    @Override
    public JSONWriter writeNull() {
        this.maybeAppendComma(false);
        this._json.append("null");
        return this;
    }

    @Override
    public JSONWriter writeNull(String name) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this._json.append("null");
        return this;
    }

    @Override
    public JSONWriter value(double number) {
        this.maybeAppendComma(false);
        this.appendJSONDouble(number);
        return this;
    }

    @Override
    public JSONWriter value(long number) {
        this.maybeAppendComma(false);
        this.appendJSONLong(number);
        return this;
    }

    @Override
    public JSONWriter value(String value) {
        this.maybeAppendComma(false);
        this.appendJSONString(value);
        return this;
    }

    @Override
    public JSONWriter value(boolean value) {
        this.maybeAppendComma(false);
        this.appendJSONBoolean(value);
        return this;
    }

    @Override
    public JSONWriter property(String name, String value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJSONString(value);
        return this;
    }

    @Override
    public JSONWriter property(String name, boolean value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJSONBoolean(value);
        return this;
    }

    @Override
    public JSONWriter property(String name, double value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJSONDouble(value);
        return this;
    }

    @Override
    public JSONWriter property(String name, long value) {
        this.maybeAppendComma(false);
        this.appendJSONString(name);
        this._json.append(':');
        this.appendJSONLong(value);
        return this;
    }

    @Override
    public void close() {
        this._json.close();
    }

    private void appendJSONString(String s) {
        this._json.append('\"');
        int _length = s.length();
        block7: for (int i = 0; i < _length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    this._json.append('\\').append('n');
                    continue block7;
                }
                case '\r': {
                    this._json.append('\\').append('r');
                    continue block7;
                }
                case '\t': {
                    this._json.append('\\').append('t');
                    continue block7;
                }
                case '\"': {
                    this._json.append('\\').append('\"');
                    continue block7;
                }
                case '\\': {
                    this._json.append('\\').append('\\');
                    continue block7;
                }
                default: {
                    if (c < '\u0010') {
                        this._json.append("\\u000").append(Integer.toHexString(c));
                        continue block7;
                    }
                    if (c < ' ') {
                        this._json.append("\\u00").append(Integer.toHexString(c));
                        continue block7;
                    }
                    this._json.append(c);
                }
            }
        }
        this._json.append('\"');
    }

    private void appendJSONLong(long number) {
        this._json.append(Long.toString(number));
    }

    private void appendJSONDouble(double number) {
        this._json.append(Double.toString(number));
    }

    private void appendJSONBoolean(boolean b) {
        this._json.append(Boolean.toString(b));
    }

    private void maybeAppendComma(boolean newcontext) {
        if (this.first) {
            if (!newcontext) {
                this.first = false;
            }
        } else {
            this._json.append(',');
        }
    }
}

