/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.pageseeder.berlioz.Beta;

public final class InitEnvironment {
    public static final String DEFAULT_MODE = "default";
    public static final String DEFAULT_CONFIG_DIRECTORY = "config";
    private final File _webInf;
    private final File _appData;
    private final String _configFolder;
    private final String _mode;

    private InitEnvironment(File webInf, File appData, String configFolder, String mode) {
        this._webInf = Objects.requireNonNull(webInf);
        this._appData = Objects.requireNonNull(appData);
        this._configFolder = Objects.requireNonNull(configFolder);
        this._mode = Objects.requireNonNull(mode);
    }

    private InitEnvironment(File webInf) {
        this._webInf = Objects.requireNonNull(webInf);
        this._appData = webInf;
        this._configFolder = DEFAULT_CONFIG_DIRECTORY;
        this._mode = DEFAULT_MODE;
    }

    public static InitEnvironment create(File webInf) {
        return new InitEnvironment(webInf);
    }

    public String mode() {
        return this._mode;
    }

    public File appData() {
        return this._appData;
    }

    public File webInf() {
        return this._webInf;
    }

    public String configFolder() {
        return this._configFolder;
    }

    @Beta
    public boolean hasAppData() {
        block4: {
            if (this._webInf == this._appData) {
                return false;
            }
            try {
                if (this._webInf.getCanonicalFile().equals(this._appData.getCanonicalFile())) {
                    return false;
                }
            }
            catch (IOException ex) {
                if (!this._webInf.getAbsoluteFile().equals(this._appData.getAbsoluteFile())) break block4;
                return false;
            }
        }
        return true;
    }

    public InitEnvironment appData(File dir) {
        InitEnvironment.checkDirectoryExists(dir);
        return new InitEnvironment(this._webInf, dir, this._configFolder, this._mode);
    }

    public InitEnvironment configFolder(String name) {
        Objects.requireNonNull(name, "The config folder name must be specified.");
        if (this._configFolder.equals(name)) {
            return this;
        }
        return new InitEnvironment(this._webInf, this._appData, name, this._mode);
    }

    public InitEnvironment mode(String mode) {
        Objects.requireNonNull(mode, "The configuration mode must be specified.");
        if (this._mode.equals(mode)) {
            return this;
        }
        return new InitEnvironment(this._webInf, this._appData, this._configFolder, mode);
    }

    public InitEnvironment webInf(File dir) {
        InitEnvironment.checkDirectoryExists(dir);
        return new InitEnvironment(dir, this._appData, this._configFolder, this._mode);
    }

    private static void checkDirectoryExists(File dir) {
        Objects.requireNonNull(dir, "The specified file " + dir + " is null");
        if (!dir.exists()) {
            throw new IllegalArgumentException("The specified file " + dir + " does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The specified file " + dir + " is not a directory.");
        }
    }
}

