/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.common.http.HttpRedirect;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;

public class UIHomeFilter
implements Filter {
    private static final Pattern GROUP_HOME_PATTERN = Pattern.compile("^/ui/([gp])/([a-z0-9\\-]+)(/admin)?/?$");

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this.doHttpFilter(req, res, chain);
    }

    private void doHttpFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String location = UIHomeFilter.redirect(req);
        if (location != null) {
            HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)location);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    private static @Nullable String redirect(HttpServletRequest req) {
        String siteprefix = GlobalSettings.getSitePrefix();
        String path = req.getRequestURI().substring(siteprefix.length());
        if (path.indexOf(46) >= 0) {
            return null;
        }
        if (path.equals("/ui") || path.equals("/ui/")) {
            return siteprefix + "/ui/account/home.html";
        }
        if (path.equals("/ui/admin") || path.equals("/ui/admin/")) {
            return siteprefix + "/ui/admin.html";
        }
        Matcher m = GROUP_HOME_PATTERN.matcher(path);
        if (m.find()) {
            String type = m.group(1);
            String name = m.group(2);
            String page = "/admin".equals(m.group(3)) ? "admin.html" : "home.html";
            return siteprefix + "/ui/" + type + "/" + name + "/" + page;
        }
        return null;
    }
}

