/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.common.properties.GlobalSettings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class UIFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this.doHttpFilter(req, res, chain);
    }

    private void doHttpFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String path = req.getRequestURI().substring(GlobalSettings.getSitePrefix().length());
        ServletContext context = req.getServletContext();
        if (path.startsWith("/ui")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/servlet/members/") || path.startsWith("/api/member-data/")) {
            context.getNamedDispatcher("com.pageseeder.member.MemberDataServlet").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/api/dbmonitor")) {
            context.getNamedDispatcher("com.pageseeder.DBMonitor").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/api/setup")) {
            context.getNamedDispatcher("com.pageseeder.Setup").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/api/authenticate")) {
            context.getNamedDispatcher("com.pageseeder.member.Authenticate").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/service/") || path.startsWith("/api/")) {
            context.getNamedDispatcher("com.pageseeder.service.ServiceServlet").forward((ServletRequest)req, (ServletResponse)res);
        } else if ("/".equals(path) || "/index.html".equals(path)) {
            context.getRequestDispatcher("/ui/home.html").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/publish/session/")) {
            context.getNamedDispatcher("com.pageseeder.developer.ResourceServlet").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/weborganic/")) {
            context.getNamedDispatcher("com.pageseeder.resource.StaticServlet").forward((ServletRequest)req, (ServletResponse)res);
        } else if (path.startsWith("/email/unsubscribe")) {
            if ("POST".equalsIgnoreCase(req.getMethod())) {
                context.getRequestDispatcher("/api/groups/" + req.getParameter("group") + "/unsubscribe.json").forward((ServletRequest)req, (ServletResponse)res);
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
        } else {
            context.getNamedDispatcher("com.pageseeder.Default").forward((ServletRequest)req, (ServletResponse)res);
        }
    }
}

