/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.SAXException;

public final class LayoutAnalytics
implements XMLWritable {
    private static final LayoutAnalytics NONE = new LayoutAnalytics("");
    private static @Nullable LayoutAnalytics cache = null;
    private final String source;

    private LayoutAnalytics(@Nullable String source) {
        this.source = source != null ? source : "";
    }

    private LayoutAnalytics(Exception ex) {
        String message = ex.getMessage().replaceAll("--+", "-");
        this.source = "<analytics><!-- " + message + " --></analytics>";
    }

    public boolean hasContent() {
        return !this.source.isEmpty();
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.writeXML(this.source);
    }

    public static LayoutAnalytics get(ServletContext context, boolean reload) {
        if (cache == null || reload) {
            cache = LayoutAnalytics.load(context);
        }
        return cache;
    }

    public static synchronized LayoutAnalytics load(ServletContext context) {
        LayoutAnalytics la = NONE;
        String contextPath = context.getRealPath("/");
        File f = new File(contextPath, "WEB-INF/config/analytics.xml");
        if (f.exists()) {
            try {
                String analytics = Files.readString(Paths.get(f.getPath(), new String[0]), StandardCharsets.UTF_8);
                Schema schema = LayoutAnalytics.loadBuiltinSchema();
                Validator validator = schema.newValidator();
                try (FileInputStream is = new FileInputStream(f);){
                    validator.validate(new StreamSource(is));
                }
                la = new LayoutAnalytics(analytics);
            }
            catch (Exception ex) {
                la = new LayoutAnalytics(ex);
            }
        }
        return la;
    }

    private static Schema loadBuiltinSchema() throws IOException, SAXException {
        String path = "/com/pageseeder/layout/library/analytics.xsd";
        try (InputStream in = LayoutAnalytics.class.getResourceAsStream(path);){
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            StreamSource source = new StreamSource(in);
            Schema schema = factory.newSchema(source);
            return schema;
        }
    }
}

