/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorRequestBase;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Member;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class BerliozGeneratorRequest
extends GeneratorRequestBase
implements GeneratorRequest {
    private final HttpServletRequest httpRequest;
    private @Nullable Member authenticatedMember = null;

    public BerliozGeneratorRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpRequest;
    }

    public @Nullable String getContent() {
        return null;
    }

    public @Nullable Member getAuthenticatedMember() {
        Long memberId;
        if (this.authenticatedMember == null && this.db != null && (memberId = SecurityUtils.getAuthenticatedMemberId((HttpServletRequest)this.httpRequest)) != null) {
            try {
                this.authenticatedMember = DatabaseQuery.getMemberById((Database)this.db, (Long)memberId);
            }
            catch (QueryFailedException ex) {
                LoggerFactory.getLogger(BerliozGeneratorRequest.class).warn("Unable to retrieve authenticated member id", (Throwable)ex);
            }
        }
        return this.authenticatedMember;
    }

    public @Nullable String getHeader(String name) {
        return this.httpRequest.getHeader(name);
    }

    public byte[] getData() {
        return new byte[0];
    }

    public OutputType getOutputType() {
        return OutputType.XML;
    }
}

