/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.IllegalCloseElementException;
import org.pageseeder.xmlwriter.UnclosedElementException;
import org.pageseeder.xmlwriter.UndeclaredNamespaceException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterBase;

public final class XMLWriterNSImpl
extends XMLWriterBase
implements XMLWriter {
    private static final PrefixMapping DEFAULT_NS = new PrefixMapping("", "");
    private static final NSElement ROOT;
    private final Map<String, String> prefixMapping = new HashMap<String, String>();
    private List<PrefixMapping> tempMapping;
    private final List<NSElement> _elements = new ArrayList<NSElement>();

    public XMLWriterNSImpl(Writer writer) throws NullPointerException {
        this(writer, false);
    }

    public XMLWriterNSImpl(Writer writer, boolean indent) throws NullPointerException {
        super(writer, indent);
        this._elements.add(ROOT);
        this.prefixMapping.put("", "");
        this.prefixMapping.put("http://www.w3.org/XML/1998/namespace", "xml");
    }

    @Override
    void deNude() throws IOException {
        if (this.isNude) {
            this._writer.write(62);
            if (this.indent && this.peekElement().hasChildren) {
                this._writer.write(10);
            }
            this.isNude = false;
        }
    }

    @Override
    public void openElement(String name) throws IOException {
        this.openElement(null, name, false);
    }

    public void openElement(String uri, String name) throws IOException {
        this.openElement(uri, name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws IOException {
        this.openElement(null, name, hasChildren);
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws IOException {
        this.deNude();
        if (this.peekElement().hasChildren) {
            this.indent();
        }
        String qName = this.getQName(uri, name);
        this._elements.add(new NSElement(qName, hasChildren, this.tempMapping));
        this._writer.write(60);
        this._writer.write(qName);
        this.handleNamespaceDeclaration();
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void closeElement() throws IOException {
        NSElement parent;
        NSElement elt = this.popElement();
        if (elt == ROOT) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        if (this.isNude) {
            this._writer.write(47);
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this._writer.write(60);
            this._writer.write(47);
            int x = elt._qName.indexOf(32);
            if (x < 0) {
                this._writer.write(elt._qName);
            } else {
                this._writer.write(elt._qName.substring(0, x));
            }
        }
        this.restorePrefixMapping(elt);
        this._writer.write(62);
        if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
            this._writer.write(10);
        }
    }

    @Override
    public void emptyElement(String element) throws IOException {
        this.emptyElement(null, element);
    }

    @Override
    public void emptyElement(String uri, String element) throws IOException {
        this.deNude();
        this.indent();
        this._writer.write(60);
        this._writer.write(this.getQName(uri, element));
        this.handleNamespaceDeclaration();
        this._writer.write(47);
        this._writer.write(62);
        if (this.indent) {
            this._writer.write(10);
        }
    }

    private NSElement peekElement() {
        return this._elements.get(this._elements.size() - 1);
    }

    private NSElement popElement() {
        return this._elements.remove(this._elements.size() - 1);
    }

    @Override
    public void attribute(String uri, String name, String value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this._writer.write(32);
        this._writer.write(this.getQName(uri, name));
        this._writer.write("=\"");
        this.writerEscape.writeAttValue(value);
        this._writer.write(34);
        this.handleNamespaceDeclaration();
    }

    @Override
    public void attribute(String uri, String name, int value) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this._writer.write(32);
        this._writer.write(this.getQName(uri, name));
        this._writer.write("=\"");
        this._writer.write(Integer.toString(value));
        this._writer.write(34);
        this.handleNamespaceDeclaration();
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws NullPointerException {
        if (!prefix.equals(this.prefixMapping.get(uri))) {
            this.removeIfNeeded(prefix);
            PrefixMapping pm = new PrefixMapping(prefix, uri);
            this.prefixMapping.put(pm.uri, pm.prefix);
            if (this.tempMapping == null) {
                this.tempMapping = new ArrayList<PrefixMapping>();
            }
            this.tempMapping.add(pm);
        }
    }

    private String getQName(String uri, String name) throws UndeclaredNamespaceException {
        String prefix = this.prefixMapping.get(uri != null ? uri : "");
        if (prefix != null) {
            if (!"".equals(prefix)) {
                return this.prefixMapping.get(uri) + ":" + name;
            }
            return name;
        }
        if (uri == null) {
            return name;
        }
        throw new UndeclaredNamespaceException(uri);
    }

    private void handleNamespaceDeclaration() throws IOException {
        if (this.tempMapping != null) {
            PrefixMapping pm = null;
            for (int i = 0; i < this.tempMapping.size(); ++i) {
                pm = this.tempMapping.get(i);
                if ("xml".equals(pm.prefix)) continue;
                this._writer.write(" xmlns");
                if (!"".equals(pm.prefix)) {
                    this._writer.write(58);
                    this._writer.write(pm.prefix);
                }
                this._writer.write("=\"");
                this._writer.write(pm.uri);
                this._writer.write("\"");
            }
            this.tempMapping = null;
        }
    }

    private void restorePrefixMapping(NSElement elt) {
        if (elt._mappings != null) {
            for (int i = 0; i < elt._mappings.size(); ++i) {
                boolean found = false;
                PrefixMapping mpi = (PrefixMapping)elt._mappings.get(i);
                block1: for (int j = this._elements.size() - 1; j > 0; --j) {
                    if (this._elements.get(j)._mappings == null) continue;
                    List mps = this._elements.get(j)._mappings;
                    for (int k = 0; k < mps.size(); ++k) {
                        PrefixMapping mpk = (PrefixMapping)mps.get(k);
                        if (!mpk.prefix.equals(mpi.prefix)) continue;
                        found = true;
                        this.removeIfNeeded(mpk.prefix);
                        this.prefixMapping.put(mpk.uri, mpk.prefix);
                        j = 0;
                        continue block1;
                    }
                }
                if (found) continue;
                this.removeIfNeeded(mpi.prefix);
            }
        }
    }

    private void removeIfNeeded(String prefix) {
        if (this.prefixMapping.containsValue(prefix)) {
            Map.Entry<String, String> remove = null;
            for (Map.Entry<String, String> e : this.prefixMapping.entrySet()) {
                if (!e.getValue().equals(prefix)) continue;
                remove = e;
                break;
            }
            this.prefixMapping.remove(remove.getKey());
        }
    }

    @Override
    public void close() throws IOException, UnclosedElementException {
        NSElement open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open._qName);
        }
        this._writer.close();
    }

    static {
        ArrayList<PrefixMapping> mps = new ArrayList<PrefixMapping>();
        mps.add(DEFAULT_NS);
        ROOT = new NSElement("", true, mps);
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix != null ? prefix : "";
            this.uri = uri != null ? uri : "";
        }
    }

    private static final class NSElement {
        private final String _qName;
        private final List<PrefixMapping> _mappings;
        private boolean hasChildren;

        public NSElement(String qName, boolean hasChildren, List<PrefixMapping> mappings) {
            this._qName = qName;
            this._mappings = mappings;
            this.hasChildren = hasChildren;
        }
    }
}

