/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLSerializable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class XMLSerializer {
    private final DateFormat _ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final XMLWriter _xml;

    public XMLSerializer(XMLWriter xml) {
        this._xml = xml;
    }

    public XMLWriter getXML() {
        return this._xml;
    }

    public void serialize(Object o, String name) throws IOException {
        if (o != null) {
            if (name.lastIndexOf(46) != -1) {
                name = name.substring(name.lastIndexOf(46) + 1);
            }
            if (name.lastIndexOf(36) != -1) {
                name = name.substring(name.lastIndexOf(36) + 1);
            }
            name = name.toLowerCase();
            if (o instanceof Number) {
                this._xml.openElement(name, false);
                this._xml.writeText(o.toString());
                this._xml.closeElement();
            } else if (o instanceof String) {
                this._xml.openElement(name, false);
                this._xml.writeText(o.toString());
                this._xml.closeElement();
            } else if (o instanceof Character) {
                this._xml.openElement(name, false);
                this._xml.writeText(((Character)o).charValue());
                this._xml.closeElement();
            } else if (o instanceof Boolean) {
                this._xml.openElement(name, false);
                this._xml.writeText(o.toString());
                this._xml.closeElement();
            } else if (o instanceof Date) {
                this._xml.openElement(name, false);
                this._xml.writeText(this._ISO8601.format((Date)o));
                this._xml.closeElement();
            } else if (o instanceof Collection) {
                this._xml.openElement(name, ((Collection)o).size() != 0);
                this.serializeCollection((Collection)o);
                this._xml.closeElement();
            } else if (o instanceof Hashtable) {
                this._xml.openElement(name, ((Hashtable)o).size() != 0);
                this.serializeHashtable((Hashtable)o);
                this._xml.closeElement();
            } else {
                this._xml.openElement(name, true);
                this.serializeObject(o);
                this._xml.closeElement();
            }
        }
    }

    public void serializeCollection(Collection<?> c) throws IOException {
        for (Object o : c) {
            this.serialize(o, o.getClass().getName());
        }
    }

    public void serializeHashtable(Map<?, ?> m) throws IOException {
        this._xml.openElement("map", !m.isEmpty());
        for (Map.Entry<?, ?> e : m.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            this._xml.openElement("element");
            this._xml.openElement("key");
            this.serialize(key, "key");
            this._xml.closeElement();
            this._xml.openElement("value");
            this.serialize(value, "value");
            this._xml.closeElement();
            this._xml.closeElement();
        }
        this._xml.closeElement();
    }

    public void serializeObject(Object o) throws IOException {
        if (o instanceof XMLSerializable) {
            try {
                Method[] meth;
                Object[] args = new Object[]{};
                Class<?> cls = o.getClass();
                for (Method element : meth = cls.getMethods()) {
                    String methodName = element.getName();
                    if (!methodName.startsWith("get") || "getClass".equals(methodName)) continue;
                    Object retObj = element.invoke(o, args);
                    String attribute = methodName.substring(3).toLowerCase();
                    this.serialize(retObj, attribute);
                }
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.getTargetException().printStackTrace();
            }
        } else if (o instanceof XMLWritable) {
            ((XMLWritable)o).toXML(this._xml);
        }
    }
}

