/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter;

import java.io.IOException;
import java.io.Writer;
import org.pageseeder.xmlwriter.XMLSerializable;
import org.pageseeder.xmlwriter.XMLSerializer;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.pageseeder.xmlwriter.esc.XMLEscapeUTF8;

public final class XML {
    private XML() {
    }

    public static String escape(String s) {
        return XMLEscapeUTF8.UTF8_ESCAPE.toElementText(s);
    }

    public static String escapeAttr(String s) {
        return XMLEscapeUTF8.UTF8_ESCAPE.toAttributeValue(s);
    }

    public static String toElementName(String name) {
        if (name == null) {
            return null;
        }
        char[] elementAsChars = name.toCharArray();
        elementAsChars[0] = !Character.isLetter(elementAsChars[0]) ? 120 : Character.toLowerCase(elementAsChars[0]);
        for (int i = 1; i < elementAsChars.length; ++i) {
            elementAsChars[i] = !Character.isLetter(elementAsChars[i]) ? 45 : Character.toLowerCase(elementAsChars[i]);
        }
        return new String(elementAsChars);
    }

    public String toString(XMLWritable o) {
        XMLStringWriter xml = new XMLStringWriter(true);
        try {
            o.toXML(xml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        xml.flush();
        return xml.toString();
    }

    public String toString(XMLSerializable o) {
        XMLStringWriter xml = new XMLStringWriter(false);
        XMLSerializer serializer = new XMLSerializer(xml);
        try {
            serializer.serializeObject(o);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xml.toString();
    }

    public XMLWriter newXMLWriter(Writer writer, NamespaceAware aware) {
        switch (aware) {
            case No: {
                return new XMLWriterImpl(writer);
            }
            case Yes: {
                return new XMLWriterNSImpl(writer);
            }
        }
        return new XMLWriterNSImpl(writer);
    }

    public static enum NamespaceAware {
        Yes,
        No;

    }
}

