/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.common.http.HttpWebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.OpenDatabaseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class WebRequest
extends HttpWebRequest {
    public WebRequest(HttpServletRequest req, HttpServletResponse res) {
        super(req, res);
    }

    public void ensureUtf8Request() {
        try {
            if (this.req.getCharacterEncoding() == null) {
                this.req.setCharacterEncoding("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public @Nullable Database getDatabase() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.sendError(502, "Failed to open database: " + ex.getMessage());
            db = null;
        }
        return db;
    }

    public void sendError(Exception ex) {
        if (ex instanceof DatabaseException) {
            this.sendError(502, ex);
        } else {
            this.sendError(500, ex);
        }
    }

    public void sendError(int status, ErrorID error, @Nullable String message) {
        if (!this.res.isCommitted()) {
            this.req.setAttribute("com.pageseeder.error.id", (Object)error.id());
        }
        this.sendError(status, Objects.toString(message, error.message()));
    }

    public void sendError(int status, ErrorID error) {
        this.sendError(status, error, null);
    }

    public static @Nullable Database getDatabase(HttpServletResponse res) {
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            int status = 502;
            String message = "Unable to open database connection";
            LoggerFactory.getLogger(WebRequest.class).error("Unable to open database connection", (Throwable)ex);
            if (res.isCommitted()) {
                WebRequest.alreadyCommitted((int)status, (String)message);
            }
            try {
                res.sendError(status, message);
            }
            catch (IOException io) {
                WebRequest.swallow((IOException)io);
            }
        }
        return db;
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, Exception ex) {
        WebRequest wr = new WebRequest(req, res);
        wr.sendError(ex);
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error, @Nullable String message) {
        WebRequest wr = new WebRequest(req, res);
        wr.sendError(status, error, message);
    }

    @Deprecated(forRemoval=true, since="6.2004")
    public static void sendError(HttpServletRequest req, HttpServletResponse res, Exception ex, ServletConfig conf) {
        WebRequest.sendError(req, res, ex);
    }

    public static void sendError(HttpServletRequest req, HttpServletResponse res, int status, ErrorID error) {
        WebRequest.sendError(req, res, status, error, null);
    }
}

