/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.web;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserDetailsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsManager.class);
    private static final String CACHE_NAME = "user-details";
    private final SafeCacheWrapper<String, UserDetails> detailsCache = SafeCacheWrapper.getInstance("user-details");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDetails get(Database db, @Nullable Long memberId, boolean archivedGroups) {
        if (memberId == null) {
            return SecurityUtils.getDefaultUserDetails();
        }
        String key = memberId + "-" + archivedGroups;
        this.detailsCache.acquireWriteLockOnKey(key);
        try {
            UserDetails details = this.detailsCache.get(key);
            if (details == null) {
                LOGGER.debug("Loading user details from DB:    {}", (Object)key);
                details = SecurityUtils.getUserDetails(db, memberId, archivedGroups);
                this.detailsCache.put(key, details);
                UserDetails userDetails = details;
                return userDetails;
            }
            LOGGER.debug("Reading user details from cache: {}", (Object)key);
            UserDetails userDetails = details;
            return userDetails;
        }
        finally {
            this.detailsCache.releaseWriteLockOnKey(key);
        }
    }

    public @Nullable UserDetails get(@Nullable Long memberId, boolean archivedGroups) {
        if (memberId == null) {
            return null;
        }
        String key = memberId + "-" + archivedGroups;
        return this.detailsCache.get(key);
    }

    public UserDetails get(Database db, @Nullable Long memberId) {
        if (memberId == null) {
            return SecurityUtils.getDefaultUserDetails();
        }
        String key = memberId + "-true";
        UserDetails details = this.detailsCache.get(key);
        if (details == null) {
            return this.get(db, memberId, false);
        }
        LOGGER.debug("Reading user details from cache: {}", (Object)key);
        return details;
    }

    public void remove(Long memberId) {
        LOGGER.debug("Removing user details from cache: {}", (Object)memberId);
        this.detailsCache.remove(memberId + "-true");
        this.detailsCache.remove(memberId + "-false");
        new MembershipCache().remove(memberId);
    }

    public void removeAll() {
        LOGGER.debug("Removing all user details from cache");
        this.detailsCache.removeAll();
        new MembershipCache().removeAll();
    }
}

