/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jdt.annotation.Nullable;

public class WrappingReader
extends Reader {
    private final Reader originalReader;
    private boolean readerFinished = false;
    private final StringBuilder before = new StringBuilder();
    private final StringBuilder after = new StringBuilder();
    private int firstIndex = 0;
    private int secondIndex = 0;

    public WrappingReader(@Nullable Reader reader, String before, String after) throws IOException {
        this(reader, before, after, false);
    }

    public WrappingReader(@Nullable Reader reader, @Nullable String before, @Nullable String after, boolean removeDoctypes) throws IOException {
        Reader reader2 = this.originalReader = reader == null ? new StringReader("") : reader;
        if (before != null) {
            this.before.append(before);
        }
        if (after != null) {
            this.after.append(after);
        }
        char[] first = new char[1];
        int read = this.originalReader.read(first);
        while (read == 1 && removeDoctypes && Character.isWhitespace(first[0])) {
            read = this.originalReader.read(first);
        }
        boolean checkedDoctype = false;
        if (read == 1) {
            if (first[0] == '<') {
                char[] beginning = new char[5];
                read = this.originalReader.read(beginning);
                if (read == 5 && new String(beginning, 0, 4).equals("?xml") && Character.isWhitespace(beginning[4])) {
                    this.skipToEndTag();
                } else if (read > 0 && removeDoctypes && new String(beginning).startsWith("!--")) {
                    this.skipToEndTag();
                } else if (read > 0) {
                    checkedDoctype = true;
                    if (removeDoctypes && new String(beginning).equals("!DOCT")) {
                        char[] next = new char[4];
                        read = this.originalReader.read(next);
                        if (read == 4 && new String(next, 0, 3).equals("YPE") && Character.isWhitespace(next[3])) {
                            this.skipToEndTag();
                        } else if (read > 0) {
                            this.before.append("<!DOCT").append(next, 0, read);
                        }
                    } else {
                        this.before.append('<').append(beginning, 0, read);
                    }
                }
            } else {
                this.before.append(first[0]);
            }
        }
        if (removeDoctypes && !checkedDoctype) {
            read = this.originalReader.read(first);
            while (read == 1 && Character.isWhitespace(first[0])) {
                read = this.originalReader.read(first);
            }
            if (read == 1) {
                if (first[0] == '<') {
                    char[] nextChars = new char[8];
                    read = this.originalReader.read(nextChars);
                    if (read == 8 && new String(nextChars).equals("!DOCTYPE")) {
                        this.skipToEndTag();
                    } else if (read > 0) {
                        this.before.append('<').append(nextChars, 0, read);
                    }
                } else {
                    this.before.append(first[0]);
                }
            }
        }
    }

    @Override
    public int read(char[] cbuf, int off, int length) throws IOException {
        int i;
        if (this.readerFinished && this.secondIndex >= this.after.length()) {
            return -1;
        }
        for (i = 0; !(i >= length || this.readerFinished && this.secondIndex >= this.after.length()); ++i) {
            char c;
            if (this.readerFinished) {
                c = this.after.charAt(this.secondIndex++);
            } else if (this.firstIndex < this.before.length()) {
                c = this.before.charAt(this.firstIndex++);
            } else {
                int r = this.originalReader.read();
                boolean bl = this.readerFinished = r == -1;
                if (this.readerFinished && this.after.length() != 0) {
                    c = this.after.charAt(this.secondIndex++);
                } else {
                    if (this.readerFinished) break;
                    c = (char)r;
                }
            }
            cbuf[off + i] = c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.originalReader.close();
    }

    private void skipToEndTag() throws IOException {
        char c;
        while ((c = (char)this.originalReader.read()) != '>') {
        }
    }
}

