/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ValidationErrorHandler
implements ErrorHandler {
    private final List<String> errors = new ArrayList<String>();

    @Override
    public void error(SAXParseException exception) throws SAXException {
        Object loc = "";
        if (exception.getLineNumber() > 0) {
            loc = exception.getColumnNumber() > 0 ? " (line: " + exception.getLineNumber() + ", column: " + exception.getColumnNumber() + ")" : " (line: " + exception.getLineNumber() + ")";
        } else if (exception.getColumnNumber() > 0) {
            loc = " (column: " + exception.getColumnNumber() + ")";
        }
        this.errors.add(exception.getMessage() + (String)loc);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        Object loc = "";
        if (exception.getLineNumber() > 0) {
            loc = exception.getColumnNumber() > 0 ? "(line: " + exception.getLineNumber() + ", column: " + exception.getColumnNumber() + ")" : "(line: " + exception.getLineNumber() + ")";
        } else if (exception.getColumnNumber() > 0) {
            loc = "(column: " + exception.getColumnNumber() + ")";
        }
        this.errors.add(exception.getMessage() + (String)loc);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    public String getErrors() {
        StringBuilder err = new StringBuilder();
        for (String e : this.errors) {
            err.append(e).append('\n');
        }
        return err.toString();
    }

    public List<String> getErrorList() {
        return this.errors;
    }
}

