/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.pageseeder.base.util.Thumbnail;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ImageThumbnail
implements Thumbnail {
    public static final int DEFAULT_SIZE = 120;
    private static final Object DEFAULT_INTERPOLATION = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private int height = 120;
    private int width = 120;
    private double ratio = this.updateRatio();
    private boolean preserve = true;

    @Override
    public void setHeight(int height) throws IllegalArgumentException {
        if (height <= 0) {
            throw new IllegalArgumentException("The maximum height must be a positive integer");
        }
        this.height = height;
        this.ratio = this.updateRatio();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(int width) throws IllegalArgumentException {
        if (width <= 0) {
            throw new IllegalArgumentException("The maximum width must be a positive integer");
        }
        this.width = width;
        this.ratio = this.updateRatio();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public boolean preserveProportions() {
        return this.preserve;
    }

    public void setPreserveProportions(boolean preserve) {
        this.preserve = preserve;
    }

    @Override
    public boolean createThumbnail(File original, File thumbnail) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(thumbnail));){
            BufferedImage image = ImageIO.read(original);
            if (image == null) {
                boolean bl = false;
                return bl;
            }
            boolean hasAlpha = original.getName().endsWith("png") || original.getName().endsWith("gif");
            ImageOrientation orientation = ImageOrientation.NORMAL;
            if (original.getName().endsWith("jpg") || original.getName().endsWith("jpeg")) {
                orientation = ImageThumbnail.getOrientation(original);
            }
            BufferedImage thumbnailImage = this.createThumbnail(image, hasAlpha, orientation);
            ImageIO.write((RenderedImage)thumbnailImage, this.preserve && !hasAlpha ? "jpeg" : "png", out);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean createThumbnail(InputStream in, File thumbnail) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(thumbnail));){
            boolean bl = this.createThumbnail(in, out);
            return bl;
        }
    }

    public boolean createThumbnail(InputStream in, OutputStream out) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(in);
        iis.mark();
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(iis);
        BufferedImage image = null;
        ImageOrientation orientation = ImageOrientation.NORMAL;
        while (imageReaders.hasNext() && image == null) {
            ImageReader reader = imageReaders.next();
            iis.reset();
            reader.setInput(iis);
            image = reader.read(0);
            orientation = ImageThumbnail.getOrientation(reader);
        }
        if (image == null) {
            return false;
        }
        boolean hasAlpha = image.getColorModel().hasAlpha();
        BufferedImage thumbnailImage = this.createThumbnail(image, hasAlpha, orientation);
        ImageIO.write((RenderedImage)thumbnailImage, this.preserve && !hasAlpha ? "jpeg" : "png", out);
        return true;
    }

    private BufferedImage createThumbnail(BufferedImage image, boolean hasAlpha, ImageOrientation orientation) {
        BufferedImage thumbnailImage;
        BufferedImage adjustedImage = this.adjustOrientation(image, orientation);
        int adjustedWidth = adjustedImage.getWidth();
        int adjustedHeight = adjustedImage.getHeight();
        if (adjustedImage.getWidth() > this.width || adjustedImage.getHeight() > this.height) {
            double adjustedRatio = (double)adjustedWidth / (double)adjustedHeight;
            adjustedHeight = this.ratio < adjustedRatio ? (int)((double)this.width / adjustedRatio) : this.height;
            int n = adjustedWidth = this.ratio > adjustedRatio ? (int)((double)this.height * adjustedRatio) : this.width;
        }
        if (this.preserve) {
            thumbnailImage = new BufferedImage(adjustedWidth, adjustedHeight, hasAlpha ? 2 : 1);
            Graphics2D graphics = thumbnailImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, DEFAULT_INTERPOLATION);
            graphics.drawImage(adjustedImage, 0, 0, adjustedWidth, adjustedHeight, null);
            graphics.dispose();
        } else {
            thumbnailImage = new BufferedImage(this.width, this.height, 2);
            Graphics2D graphics = thumbnailImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, DEFAULT_INTERPOLATION);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawImage(adjustedImage, (this.width - adjustedWidth) / 2, (this.height - adjustedHeight) / 2, adjustedWidth, adjustedHeight, null);
            graphics.dispose();
        }
        return thumbnailImage;
    }

    private double updateRatio() {
        return (double)this.width / (double)this.height;
    }

    private static ImageOrientation getOrientation(File imageFile) throws IOException {
        ImageOrientation orientation = ImageOrientation.NORMAL;
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((File)imageFile);
            Directory directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            orientation = ImageOrientation.forCode(directory.getInt(274));
        }
        catch (ImageProcessingException | MetadataException throwable) {
            // empty catch block
        }
        return orientation;
    }

    private static ImageOrientation getOrientation(ImageReader reader) throws IOException {
        if (!"JPEG".equals(reader.getFormatName())) {
            return ImageOrientation.NORMAL;
        }
        IIOMetadata metadata = reader.getImageMetadata(0);
        if (metadata != null) {
            Node node = metadata.getAsTree("javax_imageio_1.0");
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!"Dimension".equals(list.item(i).getNodeName())) continue;
                NodeList dimension = list.item(i).getChildNodes();
                for (int j = 0; j < dimension.getLength(); ++j) {
                    if (!"ImageOrientation".equals(dimension.item(j).getNodeName())) continue;
                    NamedNodeMap att = dimension.item(j).getAttributes();
                    String orientation = att.getNamedItem("value").getNodeValue();
                    return ImageOrientation.forValue(orientation);
                }
            }
        }
        return ImageOrientation.NORMAL;
    }

    private BufferedImage adjustOrientation(BufferedImage image, ImageOrientation orientation) {
        if (orientation == ImageOrientation.NORMAL) {
            return image;
        }
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        boolean rotate = orientation.isRotated();
        AffineTransformOp op = this.toAffineTransform(imageWidth, imageHeight, orientation);
        BufferedImage destinationImage = new BufferedImage(rotate ? imageHeight : imageWidth, rotate ? imageWidth : imageHeight, image.getType());
        return op.filter(image, destinationImage);
    }

    private AffineTransformOp toAffineTransform(int width, int height, ImageOrientation orientation) {
        AffineTransform affineTransform = new AffineTransform();
        switch (orientation) {
            case FLIP_H: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-width, 0.0);
                break;
            }
            case ROTATE_180: {
                affineTransform.translate(width, height);
                affineTransform.rotate(Math.PI);
                break;
            }
            case FLIP_V: {
                affineTransform.scale(1.0, -1.0);
                affineTransform.translate(0.0, -height);
                break;
            }
            case FLIP_V_ROTATE_90: {
                affineTransform.rotate(-1.5707963267948966);
                affineTransform.scale(-1.0, 1.0);
                break;
            }
            case ROTATE_270: {
                affineTransform.translate(height, 0.0);
                affineTransform.scale(1.0, 1.0);
                affineTransform.rotate(1.5707963267948966);
                break;
            }
            case FLIP_H_ROTATE_90: {
                affineTransform.scale(-1.0, 1.0);
                affineTransform.translate(-height, 0.0);
                affineTransform.translate(0.0, width);
                affineTransform.rotate(4.71238898038469);
                break;
            }
            case ROTATE_90: {
                affineTransform.translate(0.0, width);
                affineTransform.rotate(4.71238898038469);
                break;
            }
        }
        return new AffineTransformOp(affineTransform, 2);
    }

    private static enum ImageOrientation {
        NORMAL(1, "Normal"),
        FLIP_H(2, "FlipH"),
        ROTATE_180(3, "Rotate180"),
        FLIP_V(4, "FlipV"),
        FLIP_V_ROTATE_90(5, "FlipVRotate90"),
        ROTATE_270(6, "Rotate270"),
        FLIP_H_ROTATE_90(7, "FlipHRotate90"),
        ROTATE_90(8, "Rotate90");

        final int code;
        final String value;

        private ImageOrientation(int code, String value) {
            this.code = code;
            this.value = value;
        }

        public static ImageOrientation forCode(int code) {
            for (ImageOrientation orientation : ImageOrientation.values()) {
                if (orientation.code != code) continue;
                return orientation;
            }
            return NORMAL;
        }

        public static ImageOrientation forValue(String value) {
            for (ImageOrientation orientation : ImageOrientation.values()) {
                if (!value.equals(orientation.value)) continue;
                return orientation;
            }
            return NORMAL;
        }

        boolean isRotated() {
            return this.code > 4;
        }
    }
}

