/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.util;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;

public final class FileAttributes {
    public static final String PSML_LEVEL_ATTRIBUTE = "level";
    public static final String FILENAME_ATTRIBUTE = "filename";
    public static final String EXTENSION_ATTRIBUTE = "extension";
    public static final String USERTITLE_ATTRIBUTE = "title";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String BEHAVIOR_ATTRIBUTE = "behavior";
    public static final String DOCUMENTID_ATTRIBUTE = "docid";
    public static final String DOCUMENTTYPE_ATTRIBUTE = "document-type";
    public static final String LABELS_ATTRIBUTE = "labels";
    public static final String URL_ATTRIBUTE = "url";
    public static final String HAS_METADATA_ATTRIBUTE = "has-metadata";
    public static final String PUBLICATION_ID = "publication-id";
    public static final String PUBLICATION_TYPE = "publication-type";
    public static final String MALWARE = "malware";
    private static final Cache cache;

    private FileAttributes() {
    }

    public static @Nullable Map<String, String> getAttributes(File file) {
        String key = FileAttributes.getCacheKey(file);
        Element elem = cache.get((Serializable)((Object)key));
        if (elem != null) {
            if (elem.getVersion() == file.lastModified()) {
                return (Map)elem.getObjectValue();
            }
            cache.remove((Serializable)((Object)key));
        }
        return null;
    }

    public static void putAttributes(File file, Map<String, String> attributes) {
        String key = FileAttributes.getCacheKey(file);
        Element elem = new Element((Object)key, attributes);
        elem.setVersion(file.lastModified());
        cache.put(elem);
    }

    public static void clear(File file) {
        cache.remove((Serializable)((Object)FileAttributes.getCacheKey(file)));
    }

    private static String getCacheKey(File file) {
        return file.getAbsolutePath();
    }

    static {
        CacheManager manager = CacheManager.getInstance();
        cache = manager.getCache("file-inspection");
    }
}

