/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.url;

import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Role;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.xml.sax.Attributes;

public final class URLConfig
implements UniversallyPrintable {
    private final @Nullable String owner;
    private final @Nullable String urlType;
    private @Nullable String title;
    private long updated = -1L;
    private Scope scope = Scope.SERVER;
    private final List<String> domains = new ArrayList<String>();
    private final List<String> mediatypes = new ArrayList<String>();
    private final List<LabelInfo> labels = new ArrayList<LabelInfo>();
    private final List<PublishAction> publishing = new ArrayList<PublishAction>();
    private boolean publishingOverride = false;

    public URLConfig(String owner, String type) {
        this.owner = owner;
        this.urlType = type;
    }

    public URLConfig(URLConfig config) {
        Objects.requireNonNull(config, "Cannot copy a null URL Config");
        this.owner = config.owner;
        this.scope = config.scope;
        this.urlType = config.urlType;
        this.updated = config.updated;
        this.title = config.title;
        this.labels.addAll(config.labels);
        this.domains.addAll(config.domains);
        this.mediatypes.addAll(config.mediatypes);
        this.publishing.addAll(config.publishing);
        this.publishingOverride = config.publishingOverride;
    }

    public @Nullable String getURLType() {
        return this.urlType;
    }

    public void addLabels(@Nullable List<LabelInfo> labels) {
        if (labels != null) {
            this.labels.addAll(labels);
        }
    }

    public void addLabel(@Nullable LabelInfo label) {
        if (label != null && !this.labels.contains(label)) {
            this.labels.add(label);
        }
    }

    public void clearLabels() {
        this.labels.clear();
    }

    public void clearActions() {
        this.publishing.clear();
    }

    public void clearDomains() {
        this.domains.clear();
    }

    public void clearMediatypes() {
        this.mediatypes.clear();
    }

    public void addDomain(@Nullable String domain) {
        if (domain != null && !this.domains.contains(domain)) {
            this.domains.add(domain);
        }
    }

    public void addMediatype(@Nullable String mediatype) {
        if (mediatype != null && !this.mediatypes.contains(mediatype)) {
            this.mediatypes.add(mediatype);
        }
    }

    public void addPublishAction(@Nullable PublishAction action) {
        if (action != null && !this.publishing.contains(action)) {
            this.publishing.add(action);
        }
    }

    public void setPublishingOverride(boolean override) {
        this.publishingOverride = override;
    }

    public List<String> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    public List<String> getMediatypes() {
        return Collections.unmodifiableList(this.mediatypes);
    }

    public boolean matchDomain(String domain) {
        return this.domains.contains(domain);
    }

    public boolean matchMediatypes(String domain) {
        return this.mediatypes.contains(domain);
    }

    public boolean matchAnyDomain() {
        return this.domains.isEmpty();
    }

    public boolean matchAnyMediatype() {
        return this.mediatypes.isEmpty();
    }

    void setTitle(@Nullable String title) {
        this.title = title;
    }

    Scope getScope() {
        return this.scope;
    }

    void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public Date getUpdated() {
        return new Date(this.updated);
    }

    public List<String> getLabels() {
        return this.labels.stream().map(LabelInfo::name).collect(Collectors.toList());
    }

    @Override
    public void print(OutputPrinter out) {
        this.print(out, null);
    }

    public void print(OutputPrinter out, @Nullable Role role) {
        out.startObject("url-config");
        out.field("scope", this.scope.name().toLowerCase());
        if (this.owner != null) {
            out.field("template", this.owner);
        }
        if (this.urlType != null) {
            out.field("urltype", this.urlType);
        }
        if (this.updated != -1L) {
            out.field("updated", ISO8601.format((long)this.updated, (ISO8601)ISO8601.DATETIME));
        }
        out.startObject("creation");
        if (this.title != null) {
            out.field("title", this.title, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        if (!this.domains.isEmpty()) {
            out.startCollection("domains", OutputPrinter.CollectionOption.JSON_ONLY);
            for (String domain : this.domains) {
                out.startObject("domain");
                out.field("name", domain);
                out.endObject();
            }
            out.endCollection();
        }
        if (!this.mediatypes.isEmpty()) {
            out.startCollection("mediatypes", OutputPrinter.CollectionOption.JSON_ONLY);
            for (String mediatype : this.mediatypes) {
                out.startObject("media");
                out.field("type", mediatype);
                out.endObject();
            }
            out.endCollection();
        }
        out.endObject();
        if (!this.labels.isEmpty()) {
            out.startObject("labeling");
            out.startObject("labels");
            out.field("type", "url");
            for (LabelInfo label : this.labels) {
                label.print(out);
            }
            out.endObject();
            out.endObject();
        }
        this.printPublishing(out, role);
        out.endObject();
    }

    public void printPublishing(OutputPrinter out, @Nullable Role role) {
        if (!this.publishing.isEmpty()) {
            out.startObject("publishing");
            out.field("project", this.owner);
            if (this.publishingOverride) {
                out.field("override", true);
            }
            for (PublishAction action : this.publishing) {
                action.print(out, role);
            }
            out.endObject();
        }
    }

    public static class PublishAction {
        private final String type;
        private final String urlType;
        private final Map<String, Map<String, String>> targets = new HashMap<String, Map<String, String>>();
        private final Map<String, String> targetDescriptions = new HashMap<String, String>();
        private final Map<String, List<Map<String, String>>> targetParams = new HashMap<String, List<Map<String, String>>>();
        private final Map<String, Map<String, String>> paramAutosuggests = new HashMap<String, Map<String, String>>();

        public String toString() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        PublishAction(String thetype, @Nullable String urltype) {
            this.type = thetype;
            this.urlType = urltype == null || urltype.isEmpty() ? "default" : urltype;
        }

        void addTarget(String name, Map<String, String> attributes) {
            this.targets.put(name, attributes);
        }

        void addTarget(String name, Attributes attributes) {
            this.addTarget(name, PublishAction.mapFromAttributes(attributes));
        }

        void addTargetDescription(String name, String desc) {
            this.targetDescriptions.put(name, desc);
        }

        void addTargetParam(String name, Map<String, String> param) {
            this.targetParams.computeIfAbsent(name, k -> new ArrayList()).add(param);
        }

        void addTargetParam(String name, Attributes attributes) {
            this.addTargetParam(name, PublishAction.mapFromAttributes(attributes));
        }

        void setParamAutosuggest(String name, Attributes attributes) {
            this.setParamAutosuggest(name, PublishAction.mapFromAttributes(attributes));
        }

        void setParamAutosuggest(String name, Map<String, String> param) {
            this.paramAutosuggests.put(name, param);
        }

        public void print(OutputPrinter out, @Nullable Role role) {
            ArrayList<String> tempTargets = new ArrayList<String>();
            for (Map.Entry<String, Map<String, String>> entry : this.targets.entrySet()) {
                Role targetRole = Role.forAttribute((String)entry.getValue().getOrDefault("role", "contributor"));
                if (role != null && targetRole != role && !this.firstHigherOrEquals(role, targetRole)) continue;
                tempTargets.add(entry.getKey());
            }
            if (tempTargets.isEmpty()) {
                return;
            }
            out.startObject("action");
            out.field("type", this.type);
            out.startObject("source");
            out.field("type", "url");
            out.field("url-type", this.urlType);
            out.endObject();
            for (String string : tempTargets) {
                List<Map<String, String>> params;
                String desc;
                out.startObject("target");
                out.field("name", string);
                Map<String, String> atts = this.targets.get(string);
                if (atts != null) {
                    for (String name : atts.keySet()) {
                        if ("name".equals(name)) continue;
                        out.field(name, atts.getOrDefault(name, ""));
                    }
                }
                if (!(desc = this.targetDescriptions.getOrDefault(string, "")).isEmpty()) {
                    out.field("description", desc, OutputPrinter.FieldOption.XML_ELEMENT);
                }
                if ((params = this.targetParams.get(string)) != null) {
                    out.startCollection("params", OutputPrinter.CollectionOption.JSON_ONLY);
                    for (Map<String, String> param : params) {
                        out.startObject("param");
                        for (String name : param.keySet()) {
                            out.field(name, param.getOrDefault(name, ""));
                        }
                        Map<String, String> autosuggest = this.paramAutosuggests.get(param.get("name"));
                        if (autosuggest != null && !autosuggest.isEmpty()) {
                            out.startObject("autosuggest");
                            for (String name : autosuggest.keySet()) {
                                out.field(name, autosuggest.getOrDefault(name, ""));
                            }
                            out.endObject();
                        }
                        out.endObject();
                    }
                    out.endCollection();
                }
                out.endObject();
            }
            out.endObject();
        }

        private boolean firstHigherOrEquals(Role first, @Nullable Role second) {
            if (first == second || first == Role.APPROVER) {
                return true;
            }
            if (first == Role.MANAGER && second != Role.APPROVER) {
                return true;
            }
            return first == Role.CONTRIBUTOR && second != Role.APPROVER && second != Role.MANAGER;
        }

        private static Map<String, String> mapFromAttributes(Attributes attributes) {
            HashMap<String, String> all = new HashMap<String, String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i) == null ? attributes.getQName(i) : attributes.getLocalName(i);
                all.put(name, attributes.getValue(i));
            }
            return all;
        }
    }

    protected static enum Scope {
        SERVER,
        PROJECT,
        GROUP,
        DOCUMENT;

    }
}

