/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.thread;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessLogger;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.LoggerFactory;

public abstract class ProcessThread
implements Runnable,
XMLWritable,
UniversallyPrintable {
    private final String username;
    private final Long groupId;
    private final String group;
    private String name;
    private boolean wasCancelled = false;
    private boolean hasError = false;
    private boolean hasWarning = false;
    private @Nullable String threadId = null;
    private final ProcessStage status;
    private @Nullable ProcessLogger logger = null;
    private long lastUpdated;
    private Date started;
    private @Nullable String failMessage = null;

    protected ProcessThread(String username, String name, Long groupId, String groupName) {
        this.username = username;
        this.name = name;
        this.groupId = groupId;
        this.group = groupName;
        this.status = new ProcessStage(this);
        this.lastUpdated = System.currentTimeMillis();
        this.started = new Date();
    }

    protected ProcessThread(String username, String name, @Nullable Group group) {
        this.username = username;
        this.name = name;
        this.groupId = group != null ? group.getId() : -1L;
        this.group = group != null ? group.getName() : "~";
        this.status = new ProcessStage(this);
        this.lastUpdated = System.currentTimeMillis();
        this.started = new Date();
    }

    public final void setIDAndLogger(String id, ProcessLogger logger) {
        if (this.threadId == null) {
            this.threadId = id;
        }
        this.logger = logger;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final @Nullable String getFailMessage() {
        return this.failMessage;
    }

    public final String getName() {
        return this.name;
    }

    public final String getUsername() {
        return this.username;
    }

    public final @Nullable String getThreadID() {
        return this.threadId;
    }

    public final @Nullable ProcessLogger getLogger() {
        return this.logger;
    }

    public final Long getGroupID() {
        return this.groupId;
    }

    public final String getGroup() {
        return this.group;
    }

    public final boolean isFinished() {
        return this.status.isFinished();
    }

    public void cancel() {
        this.wasCancelled = true;
    }

    public final boolean hasError() {
        return this.hasError || this.failMessage != null;
    }

    public final boolean hasWarning() {
        return this.hasWarning;
    }

    public final void updateStatus(ProcessStage.Status status, String message) {
        this.updateStatus(status, message, true);
    }

    public final void fail(String message) {
        this.failMessage = message;
    }

    public final boolean wasCancelled() {
        return this.wasCancelled;
    }

    public final void complete(@Nullable String successMessage) {
        if (this.wasCancelled) {
            this.updateStatus(ProcessStage.Status.CANCELLED, this.name + " was cancelled.");
        } else if (this.failMessage != null) {
            this.updateStatus(ProcessStage.Status.FAILED, this.failMessage);
        } else if (this.hasError) {
            this.updateStatus(ProcessStage.Status.FAILED, this.name + " failed due to one or more unknown errors.");
        } else {
            this.updateStatus(ProcessStage.Status.COMPLETED, (String)(successMessage == null ? this.name + " succeeded." : successMessage));
        }
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Throwable ex) {
            LoggerFactory.getLogger(ProcessThread.class).error("Process thread failed", ex);
            String message = ex.getMessage();
            this.fail(message == null ? "An unknown error occurred in the process" : message);
            this.complete("failed");
        }
        finally {
            if (!this.status.isFinished()) {
                this.fail("The process failed to finish appropriately");
                this.complete("failed");
            }
        }
    }

    public abstract void process();

    public ProcessStage getCurrentStatus() {
        ProcessStage cloned = new ProcessStage(this);
        cloned.setMessage(this.status.getMessage());
        cloned.setStatus(this.status.getStatus());
        return cloned;
    }

    public void updateStatus(ProcessStage.Status status, @Nullable String message, boolean log) {
        this.lastUpdated = System.currentTimeMillis();
        this.status.setStatus(status);
        this.status.setMessage(message);
        if (log && this.logger != null) {
            this.logger.threadStatus(this.status);
        }
        if (status == ProcessStage.Status.ERROR) {
            this.hasError = true;
        } else if (status == ProcessStage.Status.WARNING) {
            this.hasWarning = true;
        }
    }

    public final String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Thread Id=").append(this.threadId);
        out.append(" Name=").append(this.name);
        out.append(" User=").append(this.username);
        out.append(" Group=").append(this.group);
        if (this.status != null) {
            out.append(" Status=").append((Object)this.status.getStatus());
            out.append(" Message=").append(this.status.getMessage());
        }
        return out.toString();
    }

    public final String toXML() {
        XMLOutputPrinter xml = new XMLOutputPrinter();
        this.print(xml);
        return xml.toString();
    }

    @Deprecated(since="6.0000", forRemoval=false)
    public final void toXML(XMLWriter xml) throws IOException {
        this.print(new XMLOutputPrinter(xml));
    }

    @Override
    public final void print(OutputPrinter out) {
        out.startObject("thread");
        out.field("id", this.threadId);
        out.field("name", this.name);
        out.field("username", this.username);
        out.field("groupid", this.groupId);
        out.field("started", ISO8601.format((long)this.started.getTime(), (ISO8601)ISO8601.DATETIME));
        if (this.status != null) {
            String message;
            if (this.status.getStatus() != null) {
                out.field("status", this.status.getStatus().toString().toLowerCase());
            }
            if ((message = this.status.getMessage()) != null && message.startsWith("<")) {
                out.startObject("message");
                out.field("message", message, OutputPrinter.FieldOption.XML_COPY);
                out.endObject();
            } else if (message != null) {
                out.field("message", message, OutputPrinter.FieldOption.XML_ELEMENT);
            }
        }
        this.writeThreadElements(out);
        out.endObject();
    }

    public void writeThreadElements(OutputPrinter out) {
    }

    public final long getLastUpdated() {
        return this.lastUpdated;
    }
}

