/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.state;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.state.GroupState;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupStateManager.class);
    private static final GroupStateManager SINGLETON = new GroupStateManager();
    private final SafeCacheWrapper<Long, GroupState> groupStateCache = SafeCacheWrapper.getInstance("group-state");

    private GroupStateManager() {
    }

    public static GroupStateManager singleton() {
        return SINGLETON;
    }

    public @Nullable Date getCommentsModified(Database db, @Nullable Group group) throws QueryFailedException {
        if (group == null || "admin".equals(group.getName()) || "public".equals(group.getName())) {
            return null;
        }
        Date modified = this.get(db, group.getId()).getCommentsModified();
        LOGGER.debug("Returned group {}:{} comments modified date: {}", new Object[]{group.getId(), group.getName(), modified});
        return modified;
    }

    public void setCommentsModified(@Nullable Group group, Date modified) {
        if (group == null || "admin".equals(group.getName()) || "public".equals(group.getName())) {
            return;
        }
        GroupState.Builder builder = new GroupState.Builder();
        builder.setCommentsModified(modified);
        GroupState gs = this.getFromCache(group.getId());
        if (gs != null) {
            if (modified.equals(gs.getCommentsModified())) {
                return;
            }
            builder.setURIsModified(gs.getURIsModified());
            builder.setXRefsModified(gs.getXRefsModified());
        }
        this.groupStateCache.put(group.getId(), builder.build());
        LOGGER.debug("Setting group {}:{} comments modified date:  {}", new Object[]{group.getId(), group.getName(), modified});
    }

    private GroupState get(Database db, Long groupId) throws QueryFailedException {
        GroupState state = this.groupStateCache.get(groupId);
        if (state == null) {
            LOGGER.debug("Loading group {} state from DB", (Object)groupId);
            GroupState gs = this.getFromDB(db, groupId);
            this.groupStateCache.put(groupId, gs);
            return gs;
        }
        LOGGER.debug("Reading group {} state from cache", (Object)groupId);
        return state;
    }

    private @Nullable GroupState getFromCache(Long groupId) {
        GroupState state = this.groupStateCache.get(groupId);
        if (state == null) {
            return null;
        }
        LOGGER.debug("Reading group {} state from cache", (Object)groupId);
        return state;
    }

    private GroupState getFromDB(Database db, Long groupId) throws QueryFailedException {
        Date commentDate = DatabaseQuery.getCommentLastmodifiedDate((Database)db, (Long)groupId);
        GroupState.Builder builder = new GroupState.Builder();
        builder.setCommentsModified(commentDate);
        return builder.build();
    }
}

